#!/bin/sh

PKGNAME=$2
PKGVERSION=$3
COMPONENTPARENT=/var/lib/browser-data
COMPONENTDIR=$COMPONENTPARENT/components/
add_component()
{
  if [ ! -d $COMPONENTDIR ]; then
    mkdir -p $COMPONENTDIR
  fi
  echo "<tr><td>$1</td><td>$2</td></tr>
" > $COMPONENTDIR$1
}

remove_component()
{
  if [ -d $COMPONENTDIR ] && [ -f $COMPONENTDIR$1 ]; then
     rm -f $COMPONENTDIR$1
  fi
}

if [ "$PKGNAME" != "" ]; then
  if [ "$1" == "add" ]; then
    add_component $PKGNAME $PKGVERSION
  else 
    if [ "$1" == "remove" ]; then
      remove_component $PKGNAME
    fi
  fi
fi

HEADER='<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>about:system</title>
<link rel="stylesheet" href="chrome://global/skin/about.css" type="text/css"/>
</head>
<body>
<div id="aboutPageContainer">
<div id="aboutLogoContainer">
<img height="105" src="chrome://branding/content/about.png" alt="MicroB"/>
</div>
<p style="color:blue;font-size: 200%;">Browser baseline version: 2.0</p>
<p style="font-size: 150%;">List of browser components and their versions:</p>

<table border=2 cellpadding=5>
<tr>
<th align="left">Package Name</th>
<th align="left">Version</th>
</tr>'
COMPONENTS=`cat ${COMPONENTDIR}*`
FOOTER='</table>
</body>
</html>'

echo "$HEADER 
$COMPONENTS
$FOOTER" > $COMPONENTPARENT/about-system.html
