/*
 *  tslib/plugins/pressure.c
 *
 *  Copyright (C) 2005 Nokia Corporation
 *  Author: Lauri Leukkunen <lauri.leukkunen@nokia.com>
 *
 * This file is placed under the LGPL.  Please see the file
 * COPYING for more details.
 *
 * Filter events based on pressure value variations
 * */

#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include <stdio.h>

#include "tslib.h"
#include "tslib-filter.h"

static int
pressure_read(struct tslib_module_info *info, struct ts_sample *samp, int nr)
{
	int ret;

	ret = info->next->ops->read(info->next, samp, nr);
	if (ret >= 0) {
		int n;
		for (n = 0; n < ret; n++, samp++) {
#ifdef DEBUG
                    fprintf(stderr,"BEFORE PRESSURE--------------------> %d %d %d\n",samp->x, samp->y, samp->pressure);
#endif
                    if (samp->pressure > 0) {
                        samp->pressure = 255 - samp->pressure;
                    }
                    else {
                        samp->pressure = 0;
                    }
		}
	}

	return ret;
}

static void pressure_fini(struct tslib_module_info *info)
{
	free(info);
}

static const struct tslib_ops pressure_ops =
{
	read:		pressure_read,
	fini:		pressure_fini,
};

struct tslib_module_info *mod_init(struct tsdev *dev, const char *params)
{

	struct tslib_module_info *mod;

	mod = calloc(sizeof(*mod), 1);
	if (!mod)
		return NULL;

	mod->ops = &pressure_ops;
	return mod;
}
