/*
 * Copyright (c) 2003, 2004 Nokia
 * Author: Timo Savola <tsavola@movial.fi>
 *
 * This program is licensed under GPL (see COPYING for details)
 */

#ifndef CONFIG_H
#define CONFIG_H

#include "types.h"

/** Holds the info parsed from the client's config file. */
typedef struct {
	char *target;
	char *host;
	uint16_t port;
	char **opts;
} config_t;

config_t *config_alloc(void);
void config_free(config_t *);
bool_t config_read(config_t *cfg, const char *file, const char *target);

char **get_targets(const char *filename);

#endif
