/*
 * Copyright (c) 2003, 2004 Nokia
 * Author: tsavola@movial.fi
 *
 * This program is licensed under GPL (see COPYING for details)
 */

#ifndef COMMON_H
#define COMMON_H

#include "types.h"

#include <stdio.h>

/** Default port number. */
#define DEFAULT_PORT  1202

/** Maximum username length including the nul-terminator. */
#define USER_SIZE       16

/** Maximum password length including the nul-terminator. */
#define PWD_SIZE        16

/** Maximum hostname length including the nul-terminator. */
#define HOST_SIZE      256

#define MTYPE_NFS_S    "nfs"
#define MTYPE_BIND_S   "bind"

typedef void (free_func_t)(void *);

int set_nonblocking(int fd, bool_t nonblock);
int set_closeonexec(int fd);
int setsockopt_bool(int s, int level, int optname, bool_t value);
char *get_progname(char *name);
uint32_t resolve(const char *);
void free_vec(void **vec, free_func_t *);
size_t calc_vec_len(void **vec);
ssize_t read_line(FILE *file, char *buf, size_t size);
char *skip_spaces(const char *str);
char *find_space(const char *str);
char *find_line(char *str);
char *trim_string(char *str);
int split_string(char *line, ...);
size_t string_cat(char *buf, size_t bufsize, const char *piece, ...);

/** "Out of memory" */
extern const char *oom;

/** errno = 0; error(oom); */
void oom_error(void);

/* This is defined in client.c and daemon.c */
void error(const char *msg, ...);

#endif
