/**
	@file applet_start.c

	Implements RSS Reader Settings dialog

	Copyright (c) 2004-2007 Nokia Corporation.
	Parts of code are from Liferea.
	Liferea (C) 2003,2004 Lars Lindner <lars.lindner@gmx.net>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License 
	version 2 or later, as published by the Free Software Foundation. 

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
	02110-1301 USA
	
*/
#include <stdlib.h>
#include <glib.h>
#include <gtk/gtk.h>
#include "dbus.h"
#include "debug.h"


#include <libosso.h>
#include <osso-log.h>

#include <assert.h>
#include <string.h>

#include <alarm_event.h>

#include "settings_database.h"
#include "interface.h"
#include "i18n.h"
#include "settings.h"

const gint all_cache_size[] = {1, 2, 4, 8, 0};
const gint all_autoupdate_time[] = {15, 30, 1*60, 2*60, 4*60, 8*60};

gboolean refreshnow = FALSE;

gboolean _setup_alarm_event(gboolean replace, gboolean now);
int32_t find_alarm_id();


gint find_cache_size(gint cacheSizeConf)
{
    gint cacheSize = 0;
    while (all_cache_size[cacheSize] != cacheSizeConf)
    {
        if (!all_cache_size[cacheSize])
        {
            cacheSize = 2; //default value
            break;
        } else
            cacheSize++;
    }
    return cacheSize;
}

gboolean execute_rss_settings(osso_context_t *osso, gpointer window, gboolean modal, gboolean executed_from_applet)
{
    gboolean state_exists = FALSE;
    GtkWidget *dialog = NULL;

    if (ui_activate_dialog())
        return TRUE;

    /* Create the main dialog and refresh it */
    dialog = ui_create_settings_dialog(osso, window, modal,
                                       executed_from_applet);
    
    if (dialog == NULL) 
    {
        ULOG_ERR("Unable to create applet dialog, exiting..");
        return FALSE;
    }

    gconf = gconf_client_get_default();
    config_check_first_time(gconf);

    cache_size = find_cache_size(
        gconf_client_get_int(gconf, RSS_SETTINGS_IMAGE_CACHE_SIZE, NULL));
    settings_init(&state_exists);
    if (!state_exists)
    {
        Value v;

        v.type = TYPE_BOOLEAN;
        v.boolean = gconf_client_get_bool(gconf, 
                        RSS_SETTINGS_AUTOMATIC_UPDATES, NULL);
        settings_set_value(S_AUTOMATIC_UPDATES, &v);

        v.type = TYPE_INTEGER;
        v.integer = cache_size;
        settings_set_value(S_CACHE_SIZE, &v);

        v.integer = gconf_client_get_int(gconf, 
                        RSS_SETTINGS_AUTOMATIC_UPDATES_INTERVAL, NULL);
        if (v.integer > MAX_UPDATE_INTERVAL)
            v.integer = RSS_AUTO_UPDATE_DEFAULT_INT;
        settings_set_value(S_CONN_INTERVAL, &v);

        v.integer = gconf_client_get_int(gconf, 
                        RSS_SETTINGS_AUTOMATIC_UPDATES_TYPE, NULL);
        if (v.integer < 0 || v.integer > 1)
            v.integer = 0;
        settings_set_value(S_CONN_TYPE, &v);

        v.type = TYPE_BOOLEAN;
        v.boolean = gconf_client_get_bool(gconf,
                        RSS_SETTINGS_AUTOMATIC_SCROLLING, NULL);
        settings_set_value(S_AUTOMATIC_SCROLLING, &v);

        v.type = TYPE_INTEGER;
        v.integer = gconf_client_get_int(gconf, 
                        RSS_SETTINGS_OPEN_FEEDS_TO, NULL);
        settings_set_value(S_OPEN_FEEDS_TO, &v);
    } else {
        ui_refresh();
    }

    if (ui_activate_dialog())
        return TRUE;
    
    return TRUE;
}

void close_rss_settings()
{
    ui_destroy();
}

const int32_t ALARM_FLAGS = ALARM_EVENT_NO_DIALOG |
                            ALARM_EVENT_CONNECTED |
			    ALARM_EVENT_RUN_DELAYED |
			    ALARM_EVENT_ACTIVATION;


int32_t find_alarm_id()
{
    time_t start_time = 0;
    time_t end_time = ~0;
    int32_t result = 0;

    long *events;

/*    if (end_time < 0) {
            end_time--;
    }*/
    events = alarm_event_query(start_time, end_time, ALARM_FLAGS, ALARM_FLAGS);
    if (events == NULL) {
        ULOG_ERR("Error while querying the events.\n");
    } else 
        if (*events)
        {
            unsigned int i;
            
            for (i = 0; !result && events[i]; i++) {
                alarm_event_t* event;
                
                event = alarm_event_get(events[i]);
                if (/*event->dbus_service && 
                    (strcmp(event->dbus_service, OSSS_RSS_FEED_READER_REFRESH_SERVICE) == 0) &&*/
                    event->dbus_name &&
                    (strcmp(event->dbus_name, RSS_ALARM_SIGNAL) == 0))
                        result = events[i];
                
                alarm_event_free(event);
            }
            
            free(events);
        }
    return result;
}

gboolean _setup_alarm_event(gboolean replace, gboolean now)
{
    DMSG("Entering %s %d %d\n",__FUNCTION__,replace,now);
    GConfClient* gconf = gconf_client_get_default();
//    int32_t alarm_id = find_alarm_id();

    int32_t alarm_id = gconf_client_get_int(gconf, RSS_SETTINGS_ALARM_ID, NULL);
    config_check_first_time(gconf);
    alarm_id = gconf_client_get_int(gconf, RSS_SETTINGS_ALARM_ID, NULL);
    refreshnow = now;
    DMSG("The stored ID: %d\n",alarm_id);
    
//    if (alarm_id != 0) 
    {
        if (!replace) {
            //just make sure the alarm is registered at the daemon
            alarm_event_t* event = alarm_event_get(alarm_id);
            if (event) {
                alarm_event_free(event);
                g_object_unref(gconf);

                return TRUE;
            }
//            alarm_id = 0;
        }
//        if (alarm_id)
	{
          
          DMSG("Delete alarm event %d...\n", alarm_id);
          
          int result = alarm_event_del(alarm_id);

          DMSG("Result of delete: %d\n", result);
          
          if (result == -1)
            {
              if (alarmd_get_error() == ALARMD_ERROR_NOT_RUNNING)
              {
                ULOG_ERR("Alarmd is not running\n");
                return FALSE;
              } else {
                
                ULOG_ERR("Alarmd is running but error occured -> add new event\n");
                g_timeout_add(1000, _setup_alarm_timeout, NULL);
                
                return TRUE;
              }
            } else {
              
              ULOG_ERR("Delete was successful -> add new event\n");
              
              g_timeout_add(1000, _setup_alarm_timeout, NULL);
              
              return TRUE;
            }
	}
//        gconf_client_set_int(gconf, RSS_SETTINGS_ALARM_ID, 0, NULL);
    }

  return TRUE;

}

gint _setup_alarm_timeout(gpointer data)
{

    GConfClient* gconf = gconf_client_get_default();

    gboolean autoupdate = gconf_client_get_bool(gconf, 
                        RSS_SETTINGS_AUTOMATIC_UPDATES, NULL);
    int32_t alarm_id = 0;

    ULOG_ERR("ENTER timeout to add new alarm event\n");
    
    if (autoupdate)
    {
        gint upd_interval = gconf_client_get_int(gconf, 
                            RSS_SETTINGS_AUTOMATIC_UPDATES_INTERVAL, NULL);
        if (upd_interval > MAX_UPDATE_INTERVAL)
            upd_interval = RSS_AUTO_UPDATE_DEFAULT_INT;
        upd_interval = all_autoupdate_time[upd_interval];
    
        gint upd_type = gconf_client_get_int(gconf, 
                            RSS_SETTINGS_AUTOMATIC_UPDATES_TYPE, NULL);
        if (upd_type < 0 || upd_type > 1)
            upd_type = 0;
        alarm_event_t event = {
                .alarm_time = time(NULL) + (refreshnow ? 10 : upd_interval * 60),
                .recurrence = upd_interval,
                .recurrence_count = -1,
                .snooze = 0,
                .message = NULL,
                .sound = NULL,
                .icon = NULL,
                .dbus_interface = RSS_REFRESH_INTERFACE,
                .dbus_service = RSS_REFRESH_SERVICE,
                .dbus_path = RSS_REFRESH_OBJECT_PATH,
                .dbus_name = RSS_ALARM_SIGNAL,
                .exec_name = NULL,
                .flags = ALARM_FLAGS
        };
        
        alarm_id = alarm_event_add(&event);
        if (!alarm_id)
            ULOG_ERR("Error adding alarm!\n");
        else
            gconf_client_set_int(gconf, RSS_SETTINGS_ALARM_ID, alarm_id, NULL);
    }
    
    g_object_unref(gconf);

    ULOG_ERR("LEAVE timeout to add new alarm event\n");
    
  return FALSE;

}

void setup_alarm_event(gboolean replace)
{
    _setup_alarm_event(replace, FALSE);
}

gboolean setup_alarm_event_now(gboolean replace)
{
  return _setup_alarm_event(replace, TRUE);
}

void conf_reset_default_values(GConfClient* conf)
{
    ULOG_ERR("<><><><><><><><><><><><><>\n" \
           "< Reseting gconf values  >\n" \
           "<><><><><><><><><><><><><>\n");

    gconf_client_remove_dir(conf, RSS_SETTINGS, NULL);

    gchar *path = g_strdup_printf("%s" G_DIR_SEPARATOR_S \
                        ".osso_rss_feed_reader/cache/images",
                        g_get_home_dir());
    gconf_client_set_string(conf, RSS_SETTINGS_IMAGE_CACHE_DIR, path, NULL);
    g_free(path);
    gconf_client_set_int(conf, RSS_SETTINGS_IMAGE_CACHE_SIZE, 4, NULL);
    gconf_client_set_int(conf, ZOOM_LEVEL, 100, NULL);
    gconf_client_set_bool(conf, RSS_SETTINGS_AUTOMATIC_UPDATES, TRUE, NULL);
    gconf_client_set_int(conf, RSS_SETTINGS_AUTOMATIC_UPDATES_INTERVAL, RSS_AUTO_UPDATE_DEFAULT_INT, NULL);
    gconf_client_set_int(conf, RSS_SETTINGS_AUTOMATIC_UPDATES_TYPE, 0, NULL);
    gconf_client_set_int(conf, RSS_SETTINGS_SORT_KEY, 0, NULL);
    gconf_client_set_int(conf, RSS_SETTINGS_SORT_ORDER, 1, NULL);
    gconf_client_set_bool(conf, RSS_SETTINGS_AUTOMATIC_SCROLLING, TRUE, NULL);
    gconf_client_set_int(conf, RSS_SETTINGS_OPEN_FEEDS_TO, 0, NULL);

    gconf_client_set_bool(conf, DISABLE_TOOLBAR_FULLSCREEN, FALSE, NULL);
    gconf_client_set_bool(conf, DISABLE_TOOLBAR, FALSE, NULL);
    gconf_client_set_bool(conf, LAST_WINDOW_MAXIMIZED, FALSE, NULL);
    gconf_client_set_bool(conf, LAST_SHOWFOLDERS, TRUE, NULL);

    gconf_client_set_string(conf, START_FIRST_TIME, COMPILE_TIME, NULL);

    gconf_client_add_dir(conf, RSS_SETTINGS, GCONF_CLIENT_PRELOAD_NONE, NULL);
    gconf_client_clear_cache(conf);
}

gboolean is_first_time_run(GConfClient* conf)
{
    gchar *start_first_time = gconf_client_get_string(conf, START_FIRST_TIME, NULL);
    gboolean result =   (!start_first_time ||
                         !*start_first_time /*||
                         strcmp(start_first_time,COMPILE_TIME)*/);
    g_free(start_first_time);

    ULOG_ERR("Check first time: %d\n", result);

    return result;
}

void config_check_first_time(GConfClient* conf)
{
    if (is_first_time_run(conf))
{
    ULOG_ERR("Fill with def. values\n");
        conf_reset_default_values(conf);
}
}
