/**
    @file dbus.h

    DBus related stuff common to rss-feed-reader and rss-feed-reader-applet

    Copyright (c) 2004-2007 Nokia Corporation.
    Parts of code are from Liferea.
    Liferea (C) 2003,2004 Lars Lindner <lars.lindner@gmx.net>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License 
    version 2 or later, as published by the Free Software Foundation. 

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
    02110-1301 USA
*/

#ifndef __OSSO_RSS_FEED_READER_LIB_DBUS_H__
#define __OSSO_RSS_FEED_READER_LIB_DBUS_H__


#define DBUS_API_SUBJECT_TO_CHANGE

#define RSS_SERVICE "com.nokia.osso_rss_feed_reader"
#define RSS_INTERFACE "com.nokia.osso_rss_feed_reader"
#define RSS_OBJECT_PATH "/com/nokia/osso/rss_feed_reader"


#define RSS_REFRESH_SERVICE "com.nokia.osso_rss_feed_reader_refresh"
#define RSS_REFRESH_INTERFACE "com.nokia.osso_rss_feed_reader_refresh"
#define RSS_REFRESH_OBJECT_PATH "/com/nokia/osso/rss_feed_reader_refresh"

#define RSS_ALARM_SIGNAL "autorefresh"
#define RSS_SETTINGS_ALARM_ID "/apps/osso/rss-feed-reader/alarm_id"

#define OSSO_RSS_FEED_READER_CONNECTING_STARTED "connecting_started"
#define OSSO_RSS_FEED_READER_DISPLAY_SIGNAL "display"
#define OSSO_RSS_FEED_READER_FOLDER_READ_SIGNAL "folder_read"
#define OSSO_RSS_FEED_READER_REFRESH_FINISHED_SIGNAL "refresh_finished"
#define OSSO_RSS_FEED_READER_REFRESH_INTERRUPTED_SIGNAL "refresh_interrupted"
#define OSSO_RSS_FEED_READER_REFRESH_PREVENTED_SIGNAL "refresh_prevented"
#define OSSO_RSS_FEED_READER_REFRESH_SIGNAL "refresh"
#define OSSO_RSS_FEED_READER_REFRESH_STARTED "refresh_started"
/*tvh: This will be used by osso_mime_open_*() to add a file ending with 
 *  .xml,.rss .atom or such as a feed
 *   or .opml file as a directory feed */
#define OSSO_RSS_FEED_READER_ADD_SIGNAL "mime_open"


#endif /*__OSSO_RSS_FEED_READER_LIB_DBUS_H__*/
