#include <common.h>

static gunichar2 *get_uname(const gchar *name) {
    assert(*name != '\0');
    glong uname_len;

    gunichar2 *uname = g_utf8_to_utf16(name, -1, NULL, &uname_len, NULL);

    assert(uname != NULL);
    int i;
    /* g_utf8_to_utf16 produces host-byteorder UTF-16,
     * but OBEX requires network byteorder (big endian) */
    for (i = 0; i < uname_len; i++)
      uname[i] = g_htons(uname[i]);
    return uname;
}

int main(int argc, char **argv) {
	obex_t *handle = setup2(NULL);

	obex_headerdata_t hv;
	obex_object_t *object;

	object = OBEX_ObjectNew(handle, OBEX_CMD_PUT);

	hv.bs = (unsigned char *)"text/html";;
	OBEX_ObjectAddHeader(handle, object, OBEX_HDR_TYPE, hv, strlen((char *)hv.bs), 0);
	OBEX_ObjectAddHeader(handle, object, OBEX_HDR_TYPE, hv, strlen((char *)hv.bs) + 1, 0);
	OBEX_ObjectAddHeader(handle, object, OBEX_HDR_TYPE, hv, strlen((char *)hv.bs) + 1, 0);

	hv.bs = NULL;
	OBEX_ObjectAddHeader(handle, object, OBEX_HDR_BODY, hv, 0, OBEX_FL_STREAM_START);

	hv.bs = (unsigned char *)"abc";
	OBEX_ObjectAddHeader(handle, object, OBEX_HDR_TIME, hv, strlen((char *)hv.bs), 0);
	OBEX_ObjectAddHeader(handle, object, OBEX_HDR_TIME, hv, strlen((char *)hv.bs), 0);

        hv.bq4 = 123;
        OBEX_ObjectAddHeader(handle, object, OBEX_HDR_LENGTH, hv, 4, 0);
        OBEX_ObjectAddHeader(handle, object, OBEX_HDR_LENGTH, hv, 4, 0);

	hv.bs = (unsigned char *) get_uname("abc");
	assert(hv.bs);
	OBEX_ObjectAddHeader(handle, object, OBEX_HDR_DESCRIPTION, hv, strlen((char *)hv.bs), 0);
	OBEX_ObjectAddHeader(handle, object, OBEX_HDR_DESCRIPTION, hv, strlen((char *)hv.bs), 0);

	hv.bs = (unsigned char *) get_uname("abc");
	assert(hv.bs);
	OBEX_ObjectAddHeader(handle, object, OBEX_HDR_NAME, hv, strlen((char *)hv.bs), 0);
	OBEX_ObjectAddHeader(handle, object, OBEX_HDR_NAME, hv, strlen((char *)hv.bs), 0);

        hv.bq4 = 2;
        OBEX_ObjectAddHeader(handle, object, OBEX_HDR_COUNT, hv, 4, 0);
        OBEX_ObjectAddHeader(handle, object, OBEX_HDR_COUNT, hv, 4, 0);

	request_sync(handle, object);

	return 0;
}
