/**
  @file dbus-helper.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2006 Nokia Corporation. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _DBUS_HELPER_H_
#define _DBUS_HELPER_H_

#include <stdarg.h>
#include <glib.h>
#include <dbus/dbus.h>

typedef void (*name_cb)(const char *name, gpointer user_data);

void append_dbus_args(DBusMessage *message, int first_arg_type, ...);

gboolean add_name_listener(DBusConnection *connection, const char *name,
                           name_cb func, gpointer user_data);

gboolean remove_name_listener(DBusConnection *connection, const char *name,
                              name_cb func, gpointer user_data);

#endif /* _DBUS_HELPER_H_ */
