/**
 * Copyright (C) 2007 Nokia Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */


#ifndef __MODEST_DBUS_API__
#define __MODEST_DBUS_API__


/* Note that the com.nokia service name and /com/nokia object name 
 * are what is assumed by the, bizarrely named, osso_rpc_run_with_defaults() function, 
 * so they are probably a good choice. */
#define MODEST_DBUS_NAME    "modest"
#define MODEST_DBUS_SERVICE "com.nokia."MODEST_DBUS_NAME
#define MODEST_DBUS_OBJECT  "/com/nokia/"MODEST_DBUS_NAME /* Also known as a D-Bus Path. */
#define MODEST_DBUS_IFACE   "com.nokia."MODEST_DBUS_NAME


#define MODEST_DBUS_METHOD_MAIL_TO "MailTo"
enum ModestDbusMailToArguments
{
	MODEST_DBUS_MAIL_TO_ARG_URI,
	MODEST_DBUS_MAIL_TO_ARGS_COUNT
};

#define MODEST_DBUS_METHOD_OPEN_MESSAGE "OpenMessage"
enum ModestDbusOpenMessageArguments
{
	MODEST_DBUS_OPEN_MESSAGE_ARG_URI,
	MODEST_DBUS_OPEN_MESSAGE_ARGS_COUNT
};

#define MODEST_DBUS_METHOD_SEND_RECEIVE "SendReceive"

#define MODEST_DBUS_METHOD_COMPOSE_MAIL "ComposeMail"
enum ModestDbusComposeMailArguments
{
	MODEST_DBUS_COMPOSE_MAIL_ARG_TO,
	MODEST_DBUS_COMPOSE_MAIL_ARG_CC,
	MODEST_DBUS_COMPOSE_MAIL_ARG_BCC,
	MODEST_DBUS_COMPOSE_MAIL_ARG_SUBJECT,
	MODEST_DBUS_COMPOSE_MAIL_ARG_BODY,
	MODEST_DBUS_COMPOSE_MAIL_ARG_ATTACHMENTS,
	MODEST_DBUS_COMPOSE_MAIL_ARGS_COUNT
};

#define MODEST_DBUS_METHOD_DELETE_MESSAGE "DeleteMessage"
enum ModestDbusDeleteMessageArguments
{
	MODEST_DBUS_DELETE_MESSAGE_ARG_URI,
	MODEST_DBUS_DELETE_MESSAGE_ARGS_COUNT
};

#define MODEST_DBUS_METHOD_OPEN_DEFAULT_INBOX "OpenDefaultInbox"

/* These are handle via normal D-Bus instead of osso-rpc: */
#define MODEST_DBUS_METHOD_SEARCH "Search"
#define MODEST_DBUS_METHOD_GET_FOLDERS "GetFolders"

/** This is an undocumented hildon-desktop method that is 
 * sent to applications when they are started from the menu,
 * but not when started from D-Bus activation, so that 
 * applications can be started without visible UI.
 * At least, I think so. murrayc.
 **/
#define MODEST_DBUS_METHOD_TOP_APPLICATION "top_application"

#endif /* __MODEST_DBUS_API__ */
