
/**
 * This file is part of osso-email-common
 *
 * Copyright (c) 2006 Nokia Corporation.
 * 
 * Contact: Dirk-Jan Binnema <dirk-jan.binnema@nokia.com>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef __XML_CACHE_H__
#define __XML_CACHE_H__

#include <stdlib.h>		/* for size_t */
#include <glib.h>
#include <libosso.h>


#define XML_CACHE_FILE "cache.xml"

#define XML_CHECK_STATUS(condition, message,  iffail)   \
{                                                       \
	if(condition)  {                                \
		osso_log(LOG_INFO, " %s\n",message);    \
		 iffail;                                \
        }                                               \
}

/**
 * check if the xml cache for the given folder is up to date
 *
 * @param folder_name folder path of the folder 
 * @param arch_path folder path in case of archival folder
 *
 * @return TRUE if the cache is up to date, FALSE otherwise
 */
gboolean xml_cache_is_up_to_date(gchar * folder_name, gchar * arch_path);


/**
 * get the xml cache data for the given folder
 *
 * @param folder_name name of the folder to get the cache for
 * @index Index of file to to be used for reading the contents
 *
 * @return the xml data, or NULL in case of error
 */
gchar *xml_cache_get(const gchar * folder_name, gint index);


/**
 * update the cache with new data
 *
 * @param folder_name the name of the folder to update the cache for
 * @param xmldata the xmldata with which to fill the cache
 * @param size the size of the xml data
 * @param index number is messages sent already
 * @param is_last whether its the last file(cache.xml) to be used
 *
 * @return TRUE if the update succeeded, FALSE otherwise
 */
gboolean xml_cache_update(const gchar * folder_name, const gchar * xmldat,
			  size_t size, gint index, gboolean is_last);


/*
 This function removes all cache files in a directory

 @param xml_cache - cache file path
 
 @return void
*/
void xml_cache_remove(gchar * xml_cache);

#endif /*__XML_CACHE_H__*/
