
/**
 * This file is part of osso-email-common
 *
 * Copyright (c) 2006 Nokia Corporation.
 * 
 * Contact: Dirk-Jan Binnema <dirk-jan.binnema@nokia.com>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef STATESAVE_H_
#define STATESAVE_H_

typedef struct _OpenedWindowData OpenedWindowData;
typedef struct _FolderSortInfo FolderSortInfo;
typedef struct _EmailStateInfo EmailStateInfo;
typedef struct _EmailPersistentInfo EmailPersistentInfo;

struct _OpenedWindowData {
	gchar *msgid;
	guint msgNum;
	guint topSequence;
	gpointer *window_ptr;
	gchar *oldmsgid;
	gboolean iseditor;
	guint scroll_position;
	guint zoom_percentage;
	guint cursor_x_pos;
	guint cursor_y_pos;
	gboolean tool_bar_hidden;
};

struct _FolderSortInfo {
	gchar *name;
	guint sort_key;
	guint sort_order;
};

struct _EmailStateInfo {
	gboolean oom_signal_received;
	gboolean split_view_mode;
	gboolean full_screen_mode;
	gboolean tool_bar_hidden;
	gboolean cc_field_on;
	gboolean bcc_field_on;
	guint folderview_scroll_position;
	guint msgview_scroll_position;
	gchar *current_folder;
	gchar *current_msg_id;
	GSList *marked_msgs;	//List of message id strings
	GSList *folder_sort_info_list;	//List of FolderInfo structures
	GSList *open_msgs_list;	//List of OpenWindowData structures
	GSList *msgheaders_list;
};

struct _EmailPersistentInfo {
	gboolean split_view_mode;
	gint mainview_pane_pos;
	gint listview_from_col_width;
	gint listview_subject_col_width;
	gboolean mainview_tool_bar_hidden;
	gboolean viewer_tool_bar_hidden;
	gboolean editor_tool_bar_hidden;
	gboolean mainview_fullscreen_tool_bar_hidden;
	gboolean viewer_fullscreen_tool_bar_hidden;
	gboolean editor_fullscreen_tool_bar_hidden;
	gboolean cc_field_on;
	gboolean bcc_field_on;
	gboolean read_receipt;
	gint msg_size_limit;
	gboolean play_sound;
	gint msg_format_type;
	gboolean inc_original;
	gboolean delete_servermail_also;
	gint sent_folder_clean_time_stamp;
	gint sent_folder_clean_option;
	gint sent_folder_clean_time_value;
	gint viewing_html_fontname_index;
	gint viewing_plain_fontname_index;
	gint editing_html_fontname_index;
	gint editing_plain_fontname_index;
	GSList *folder_sort_info_list;
};

#endif
