
/*
 * LibSylph -- E-Mail client library
 * Copyright (C) 1999-2006 Hiroyuki Yamamoto
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __SSL_H__
#define __SSL_H__

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#if USE_SSL

#include <glib.h>
#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/ssl.h>
#include <openssl/err.h>

#include "socket.h"

#define SSL_SUCCESS 			0

#define SSL_ERROR_BASE 			8000

#define	SSL_INIT_FAILED			SSL_ERROR_BASE + 1
#define	SSL_SERVER_NOT_SUPPORTED	SSL_ERROR_BASE + 2
#define	SSL_SOCKET_CONNECTION_FAILED	SSL_ERROR_BASE + 3
#define	SSL_INVALID_SSL_METHOD		SSL_ERROR_BASE + 4
#define	SSL_LOAD_CIPHER_LIST_FAILED	SSL_ERROR_BASE + 5
#define	SSL_CIPHER_NOT_SUPPORTED	SSL_ERROR_BASE + 6
#define	SSL_CIPHER_KEY_NOT_SUPPORTED	SSL_ERROR_BASE + 7
#define	SSL_CIPHER_KEY_STRENGTH_NOT_SUPPORTED 	SSL_ERROR_BASE + 8
#define	SSL_SERVER_CERT_NULL		SSL_ERROR_BASE + 9
#define	SSL_SERVER_CERT_INVALID		SSL_ERROR_BASE + 10
#define	SSL_SERVER_CERT_EXPIRED		SSL_ERROR_BASE + 11
#define	SSL_SERVER_CERT_DOMAIN_INVALID	SSL_ERROR_BASE + 12
#define	SSL_ROOTCA_LIST_NULL		SSL_ERROR_BASE + 13
#define	SSL_NOT_ABLE_TO_READ_ROOTCA_LIST	SSL_ERROR_BASE + 14
#define	SSL_INTERNAL_ERROR		SSL_ERROR_BASE + 15
#define	SSL_CIPHER_NOT_FOUND		SSL_ERROR_BASE + 16


typedef enum {
	SSL_METHOD_SSLv23,
	SSL_METHOD_TLSv1
} SSLMethod;

typedef enum {
	SSL_NONE,
	SSL_TUNNEL,
	SSL_STARTTLS
} SSLType;

gint ssl_init(void);
void ssl_done(void);
gint ssl_init_socket(SockInfo * sockinfo);
gint ssl_init_socket_with_method(SockInfo * sockinfo, SSLMethod method);
void ssl_done_socket(SockInfo * sockinfo);
gchar *hostaddr_to_hostname(gchar * addr);



#endif				/* USE_SSL */

#endif				/* __SSL_H__ */
