
/*
 * LibSylph -- E-Mail client library
 * Copyright (C) 1999-2006 Hiroyuki Yamamoto
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif
#ifdef USE_SSL

#include "defs.h"

#include <glib.h>

#include "intl.h"
#include "utils.h"
#include "ssl.h"
#include <netinet/in.h>
#include <arpa/inet.h>

#define STRENGTH_LIMIT 128

static SSL_CTX *ssl_ctx_SSLv23;
static SSL_CTX *ssl_ctx_TLSv1;

gint ssl_error = SSL_SUCCESS;

gchar *cipher_list =
    "DES-CBC3-MD5:DES-CBC-MD5:EXP-RC2-MD5:RC2-MD5:EXP-RC4-MD5:RC4-MD5:AES256-SHA:AES128-SHA:DES-CBC3-SHA:DES-CBC-SHA:EXP-DES-CBC-SHA:EXP-RC2-CBC-MD5:RC4-SHA:RC4-MD5:EXP-RC4-MD5:NULL-SHA:NULL-MD5";
/*
static int verify_callback ( int ok, X509_STORE_CTX * ctx );
*//* commented for demo purpose */
gchar *hostaddr_to_hostname(gchar * addr);

gint ssl_init(void)
{
	SSL_library_init();
	SSL_load_error_strings();
	gint retval = SSL_SUCCESS;

	ssl_ctx_SSLv23 = SSL_CTX_new(SSLv23_client_method());
	if (ssl_ctx_SSLv23 == NULL) {
		retval = SSL_INIT_FAILED;
		debug_print("SSLv23 not available\n");
	} else {
		debug_print("SSLv23 available\n");
	}

	ssl_ctx_TLSv1 = SSL_CTX_new(TLSv1_client_method());
	if (ssl_ctx_TLSv1 == NULL) {
		retval = SSL_INIT_FAILED;
		debug_print("TLSv1 not available\n");
	} else {
		debug_print("TLSv1 available\n");
	}
	ssl_error = retval;
	return retval;
}

void ssl_done(void)
{
	if (ssl_ctx_SSLv23) {
		SSL_CTX_free(ssl_ctx_SSLv23);
	}

	if (ssl_ctx_TLSv1) {
		SSL_CTX_free(ssl_ctx_TLSv1);
	}
}

gint ssl_init_socket(SockInfo * sockinfo)
{
	return ssl_init_socket_with_method(sockinfo, SSL_METHOD_SSLv23);
}

gint ssl_init_socket_with_method(SockInfo * sockinfo, SSLMethod method)
{
	X509 *server_cert = NULL;
	gint ret = 0;
	/*SSL_CIPHER *ciph = NULL; */
	gchar peer_CN[256];
	gchar *str = NULL;
	/* gint bits = 0; */
	/*
	   gchar *ca_path = NULL;
 *//* commented for demo purpose */
	/*gchar *server_name = NULL;
	   gchar *server_addr = NULL;
	   gchar *cipher_name = NULL;
	 */
	gchar *ca_file = NULL;

	ssl_error = SSL_SUCCESS;
	memset(peer_CN, '\0', 256);

/*
    ca_file =
        g_strdup_printf ( "%s%c%s%c%s", STANDARD_PATH, G_DIR_SEPARATOR,
                          CERT_DIR, G_DIR_SEPARATOR, CA_LIST );
    if ( ca_file == NULL ) {
        ssl_error = SSL_INTERNAL_ERROR;
        return SSL_INTERNAL_ERROR;
    }

    if ( !is_file_exist ( ca_file ) ) {
        g_free ( ca_file );
        ssl_error = SSL_ROOTCA_LIST_NULL;
        return SSL_ROOTCA_LIST_NULL;
    }
*///commented for demo purpose
	switch (method) {
	case SSL_METHOD_SSLv23:
		if (!ssl_ctx_SSLv23) {
			g_free(ca_file);
			ssl_error = SSL_INVALID_SSL_METHOD;
			return SSL_INVALID_SSL_METHOD;
		}
/* new code start */
		if (SSL_CTX_set_cipher_list(ssl_ctx_SSLv23, cipher_list) == 0) {
			g_free(ca_file);
			ssl_error = SSL_LOAD_CIPHER_LIST_FAILED;
			return SSL_LOAD_CIPHER_LIST_FAILED;
		}
/* new code end */
		sockinfo->ssl = SSL_new(ssl_ctx_SSLv23);
		break;
	case SSL_METHOD_TLSv1:
		if (!ssl_ctx_TLSv1) {
			g_free(ca_file);
			ssl_error = SSL_INVALID_SSL_METHOD;
			return SSL_INVALID_SSL_METHOD;
		}
/* new code start */
		if (SSL_CTX_set_cipher_list(ssl_ctx_TLSv1, cipher_list) == 0) {
			g_free(ca_file);
			ssl_error = SSL_LOAD_CIPHER_LIST_FAILED;
			return SSL_LOAD_CIPHER_LIST_FAILED;
		}
/* new code end */
		sockinfo->ssl = SSL_new(ssl_ctx_TLSv1);
		break;
	default:
		g_free(ca_file);
		ssl_error = SSL_INVALID_SSL_METHOD;
		return SSL_INVALID_SSL_METHOD;
		break;
	}

	if (sockinfo->ssl == NULL) {
		ssl_error = SSL_INIT_FAILED;
		return SSL_INIT_FAILED;
	}

	SSL_set_fd(sockinfo->ssl, sockinfo->sock);
	if ((ret = SSL_connect(sockinfo->ssl)) == -1) {
		g_free(ca_file);
		ssl_error = SSL_SOCKET_CONNECTION_FAILED;
		return SSL_SOCKET_CONNECTION_FAILED;
	}

	/* Get the cipher */

	debug_print("SSL connection using %s\n", SSL_get_cipher(sockinfo->ssl));

	/* Get server's certificate (note: beware of dynamic allocation) */

	if ((server_cert = SSL_get_peer_certificate(sockinfo->ssl)) != NULL) {
		debug_print("Server certificate:\n");

		if ((str = X509_NAME_oneline(X509_get_subject_name(server_cert), 0, 0)) != NULL) {
			debug_print("  Subject: %s\n", str);
			free(str);
		}

		if ((str = X509_NAME_oneline(X509_get_issuer_name(server_cert), 0, 0)) != NULL) {
			debug_print("  Issuer: %s\n", str);
			free(str);
		}
/* new code start */
#if 0
		if (X509_cmp_current_time(X509_get_notBefore(server_cert)) < 0
		    && X509_cmp_current_time(X509_get_notAfter(server_cert)) > 0) {
			debug_print("time period is valid\n");
		} else {
			debug_print("time period is in valid\n");
			g_free(ca_file);
			ssl_error = SSL_SERVER_CERT_EXPIRED;
			return SSL_SERVER_CERT_EXPIRED;
		}
		server_addr = g_strdup(sockinfo->hostname);
		server_name = (gchar *) hostaddr_to_hostname(server_addr);
		if (server_name == NULL) {
			debug_print("server_name not found \n");
			g_free(server_addr);
			g_free(ca_file);
			ssl_error = SSL_INIT_FAILED;
			return SSL_INIT_FAILED;
		}
		g_free(server_addr);

		X509_NAME_get_text_by_NID(X509_get_subject_name(server_cert),
					  NID_commonName, peer_CN, 256);
		debug_print("server name : %s \n", peer_CN);

		if (g_ascii_strncasecmp(server_name, peer_CN, strlen(server_name)) != 0) {
			debug_print(" in valid server\n");
			g_free(server_name);
			g_free(ca_file);
			ssl_error = SSL_SERVER_CERT_DOMAIN_INVALID;
			return SSL_SERVER_CERT_DOMAIN_INVALID;
		}

		g_free(server_name);

		ciph = (SSL_CIPHER *) SSL_get_current_cipher(sockinfo->ssl);
		cipher_name = (gchar *) SSL_CIPHER_get_name((SSL_CIPHER *) ciph);
		if (cipher_name == NULL) {
			g_free(ca_file);
			ssl_error = SSL_CIPHER_NOT_FOUND;
			return SSL_CIPHER_NOT_FOUND;
		}
		debug_print(" cipher name : %s \n", cipher_name);
		if (strstr(cipher_list, cipher_name) == NULL) {
			g_free(ca_file);
			g_free(cipher_name);
			ssl_error = SSL_CIPHER_NOT_SUPPORTED;
			return SSL_CIPHER_NOT_SUPPORTED;
		}
		debug_print(" cipher version : %s \n", SSL_CIPHER_get_version(ciph));
		debug_print(" cipher  size : %d \n", SSL_CIPHER_get_bits(ciph, NULL));

		SSL_CIPHER_get_bits(ciph, &bits);
		debug_print(" cipher bits : %d \n", bits);

		if (bits > STRENGTH_LIMIT) {
			debug_print("strength :%d is more than the STRENGTH_LIMIT:%d\n",
				    bits, STRENGTH_LIMIT);
			g_free(ca_file);
			ssl_error = SSL_CIPHER_KEY_STRENGTH_NOT_SUPPORTED;
			return SSL_CIPHER_KEY_STRENGTH_NOT_SUPPORTED;
		}
#endif
		/*
		   ca_path = g_strdup_printf ( "%s%c%s", STANDARD_PATH,
		   G_DIR_SEPARATOR, CERT_DIR );
		   if ( ca_path == NULL ) {
		   g_free(ca_file);
		   ssl_error = SSL_INTERNAL_ERROR;
		   return SSL_INTERNAL_ERROR;
		   }
		   switch ( method ) {
		   case SSL_METHOD_SSLv23:
		   if ( ssl_ctx_SSLv23 ) {
		   if ( !( SSL_CTX_load_verify_locations ( ssl_ctx_SSLv23,
		   ca_file, NULL ) ) ) {
		   debug_print ( "cannot read CA list \n" );
		   g_free(ca_file);
		   ssl_error = SSL_NOT_ABLE_TO_READ_ROOTCA_LIST;
		   return SSL_NOT_ABLE_TO_READ_ROOTCA_LIST;
		   }
		   SSL_CTX_set_verify ( ssl_ctx_SSLv23, SSL_VERIFY_PEER,
		   verify_callback );
		   if ( ssl_error != SSL_SUCCESS ) {
		   g_free(ca_file);
		   return ssl_error;
		   }
		   g_free(ca_file);
		   } else {
		   ssl_error = SSL_INIT_FAILED;
		   g_free(ca_file);
		   return SSL_INIT_FAILED;
		   }
		   break;
		   case SSL_METHOD_TLSv1:
		   if ( ssl_ctx_TLSv1 ) {
		   if ( !( SSL_CTX_load_verify_locations ( ssl_ctx_TLSv1,
		   ca_file, NULL ) ) ) {
		   debug_print ( "cannot read CA list \n" );
		   ssl_error = SSL_NOT_ABLE_TO_READ_ROOTCA_LIST;
		   g_free(ca_file);
		   return SSL_NOT_ABLE_TO_READ_ROOTCA_LIST;
		   }
		   SSL_CTX_set_verify ( ssl_ctx_TLSv1, SSL_VERIFY_PEER,
		   verify_callback );
		   if ( ssl_error != SSL_SUCCESS ) {
		   g_free(ca_file);
		   return ssl_error;
		   }

		   g_free(ca_file);
		   } else {
		   g_free(ca_file);
		   ssl_error = SSL_INIT_FAILED;
		   return SSL_INIT_FAILED;
		   }
		   break;
		   default:
		   g_free(ca_file);
		   debug_print ( "invalid method\n" );
		   ssl_error = SSL_INIT_FAILED;
		   return SSL_INIT_FAILED;
		   break;
		   }
		 */
/*new code end*//* commented for demo purpose */

		X509_free(server_cert);
	} else {
		ssl_error = SSL_SERVER_CERT_NULL;
		return SSL_SERVER_CERT_NULL;
	}

	ssl_error = SSL_SUCCESS;
	return SSL_SUCCESS;
}

void ssl_done_socket(SockInfo * sockinfo)
{
	if (sockinfo->ssl) {
		SSL_free(sockinfo->ssl);
	}
}

/* new code start */
/*
static int
verify_callback ( int ok, X509_STORE_CTX * ctx )
{
    gchar *s = NULL, buf[256];
    memset ( buf, '\0', 256 );
    s = X509_NAME_oneline ( X509_get_subject_name ( ctx->current_cert ), buf,
                            sizeof buf );
    if ( s != NULL ) {
        if ( ok ) {
            fprintf ( stderr, "depth=%d %s\n", ctx->error_depth, buf );
        } else {
            fprintf ( stderr, "depth=%d error=%d %s\n",
                      ctx->error_depth, ctx->error, buf );
        }
    }

    if ( ok == 0 ) {
        switch ( ctx->error ) {
          case X509_V_ERR_CERT_NOT_YET_VALID:
          case X509_V_ERR_CERT_HAS_EXPIRED:
          case X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT:
              ssl_error = SSL_SERVER_CERT_INVALID;
        }
    }
    return ( ok );
}
*//* commented for demo purposes */

gchar *hostaddr_to_hostname(gchar * addr)
{
	struct hostent *he = NULL;
	struct sockaddr_in saddr;
	gchar *server_name = NULL;
	memset(&saddr, 0, sizeof(saddr));
	saddr.sin_family = AF_INET;
	saddr.sin_addr.s_addr = inet_addr(addr);
	saddr.sin_port = htons(0);
	he = gethostbyaddr((char *) &saddr.sin_addr, sizeof(saddr.sin_addr), AF_INET);

	if (he == NULL) {
		debug_print("gethostbyaddr failed \n");
		return NULL;
	}
	if (he->h_name == NULL) {
		debug_print("not able to find the name of the server :%s\n", addr);
		return NULL;
	}
	server_name = g_strdup(he->h_name);
	return server_name;
}

/* new code end */

#endif				/* USE_SSL */
