
/**
 * This file is part of osso-email-common
 *
 * Copyright (c) 2006 Nokia Corporation.
 * 
 * Contact: Dirk-Jan Binnema <dirk-jan.binnema@nokia.com>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef __SMTP_ERROR_CODES_H__
#define __SMTP_ERROR_CODES_H_

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#if HAVE_PATHS_H
#include <paths.h>
#endif

#if HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif

#include "callbacks.h"

extern SmtpCallback *smtp_cb;

#define IS_PARAM_NULL( param, errorcode, iffail)           \
{                                                                \
  if(!param) {                                                   \
     if ((smtp_cb != NULL) &&                                    \
         (smtp_cb-> smtp_param_value_missing_cb != NULL)) {      \
         smtp_cb->smtp_param_value_missing_cb (errorcode);       \
     }                                                           \
     iffail;                                                     \
  }                                                              \
}

#define SMTP_PARAM_VALUE_MISSING_CB(errorcode)                   \
{                                                                \
  if(errorcode) {                                                \
     if ((smtp_cb != NULL) &&                                    \
         (smtp_cb-> smtp_param_value_missing_cb != NULL)) {      \
         smtp_cb->smtp_param_value_missing_cb (errorcode);       \
     }                                                           \
     debug_print("[%s][%d] : Missing Param : %d",__FILE__,__LINE__,errorcode);\
  }                                                              \
}


#define SMTP_UPDATE_FOLDER_VIEW_CB(header, flag, status)                \
{                                                               \
  if(header) {                                                  \
     if ((smtp_cb != NULL) &&                                   \
         (smtp_cb-> smtp_update_folder_view_cb)) {              \
         smtp_cb->smtp_update_folder_view_cb (header, flag, status);    \
     }                                                          \
     debug_print("[%s][%d] : Update Folder : %d",__FILE__,__LINE__,flag);\
  }                                                             \
}

#define SMTP_SET_MSG_CB(retval, param1, param2)                 \
{                                                               \
   if ((smtp_cb != NULL) &&                                     \
       (smtp_cb->smtp_set_msg_cb)) {                            \
       smtp_cb->smtp_set_msg_cb (retval, param1, param2 );      \
   }                                                            \
   debug_print("[%s][%d] : set msg cb : %d",__FILE__,__LINE__, retval);\
}

#define SMTP_UPDATE_OUTBOX_MAIL_COUNT( totalMails, mailsSent)   \
{                                                               \
   if ((smtp_cb != NULL) &&                                     \
       (smtp_cb->smtp_update_outbox_mail_count)) {              \
       smtp_cb->smtp_update_outbox_mail_count (totalMails, mailsSent); \
   }                                                            \
   debug_print("[%s][%d] :update outbox mail count: %d",__FILE__,__LINE__, retval);\
}

#define SMTP_SEND_COMPLETE_CB( )                                \
{                                                               \
   if ((smtp_cb != NULL) &&                                     \
       (smtp_cb->smtp_send_complete_cb)) {                      \
       smtp_cb->smtp_send_complete_cb ();                       \
   }                                                            \
}

#define CHECK_PARAM_IS_NULL( param, errorcode)                   \
{                                                                \
  if(!param) {                                                   \
     if ((smtp_cb != NULL) &&                                    \
         (smtp_cb-> smtp_param_value_missing_cb)) {              \
         smtp_cb->smtp_param_value_missing_cb (errorcode);       \
     }                                                           \
     return errorcode;                                           \
  }                                                              \
}


#define 	SMTP_ERROR_BASE 			1000

#define 	SMTP_RCPT_LIST_INVALID			(SMTP_ERROR_BASE+1)
#define 	SMTP_SUBJECT_IS_EMPTY			(SMTP_ERROR_BASE+2)
#define 	SMTP_FILE_WRITE_ERROR			(SMTP_ERROR_BASE+3)
#define 	SMTP_WRITE_HEADERS_ERROR		(SMTP_ERROR_BASE+4)
#define 	SMTP_FILE_POINTER_NULL			(SMTP_ERROR_BASE+5)
#define 	SMTP_CHARSET_NULL			(SMTP_ERROR_BASE+6)
#define 	SMTP_ACCOUNT_NULL			(SMTP_ERROR_BASE+7)
#define 	SMTP_EMAIL_ADDRESS_NULL 		(SMTP_ERROR_BASE+8)
#define 	SMTP_FILE_CLOSE_ERROR			(SMTP_ERROR_BASE+9)
#define 	SMTP_MESSAGE_NULL			(SMTP_ERROR_BASE+10)
#define 	SMTP_MESSAGE_INFO_NULL			(SMTP_ERROR_BASE+11)
#define 	SMTP_ATTACH_LIST_NULL			(SMTP_ERROR_BASE+12)
#define 	SMTP_CONNECTING_TO_SERVER		(SMTP_ERROR_BASE+13)
#define 	SMTP_BAD_RESPONSE			(SMTP_ERROR_BASE+14)
#define 	SMTP_ACCOUNT_NAME_INVALID		(SMTP_ERROR_BASE+15)
#define 	SMTP_EMAIL_INVALID			(SMTP_ERROR_BASE+16)
#define 	SMTP_USERID_INVALID			(SMTP_ERROR_BASE+17)
#define 	SMTP_PASSWD_INVALID			(SMTP_ERROR_BASE+18)
#define 	SMTP_SERVER_INVALID			(SMTP_ERROR_BASE+19)
#define 	SMTP_AUTHTYPE_INVALID			(SMTP_ERROR_BASE+20)
#define 	SMTP_ATTACH_LIST_INVALID		(SMTP_ERROR_BASE+21)
#define 	SMTP_INIT_FAILED			(SMTP_ERROR_BASE+22)
#define 	SMTP_FILE_NAME_NULL			(SMTP_ERROR_BASE+23)

#define 	SMTP_FILE_NAME_NULL			(SMTP_ERROR_BASE+23)
#define 	SMTP_MSG_HDR_NULL			(SMTP_ERROR_BASE+24)
#define 	SMTP_FILE_OPEN_ERROR			(SMTP_ERROR_BASE+25)
#define 	SMTP_SESSION_INVALID			(SMTP_ERROR_BASE+26)
#define 	SMTP_SESSION_CREATE_ERROR		(SMTP_ERROR_BASE+27)
#define 	SMTP_SESSION_CONNECT_ERROR		(SMTP_ERROR_BASE+28)
#define 	SMTP_SESSION_FROM_ERROR 		(SMTP_ERROR_BASE+29)

#define 	SMTP_INTERNAL_ERROR			(SMTP_ERROR_BASE+30)
#define 	SMTP_SEND_ERROR 			(SMTP_ERROR_BASE+31)
#define 	SMTP_AUTHENTICATION_FAIL_ERROR		(SMTP_ERROR_BASE+32)
#define 	SMTP_COPYTO_SENT_FOLDER_ERROR		(SMTP_ERROR_BASE+33)
#define 	SMTP_COPYTO_OUT_FOLDER_ERROR		(SMTP_ERROR_BASE+34)
#define 	SMTP_COPYTO_DRAFT_FOLDER_ERROR		(SMTP_ERROR_BASE+35)

#define		SMTP_AUTHENTICATING			(SMTP_ERROR_BASE+36)
#define		SMTP_SENDING				(SMTP_ERROR_BASE+37)
#define		SMTP_QUITTING				(SMTP_ERROR_BASE+38)
#define         SMTP_CANCEL_MAIL                        (SMTP_ERROR_BASE+39)
#define		SMTP_PASSWD_FAIL			(SMTP_ERROR_BASE+40)
#define		SMTP_INVALID_EMAIL_ADDRESS		(SMTP_ERROR_BASE+41)
#define		SMTP_START		                (SMTP_ERROR_BASE+42)
#define         SMTP_FLIGHT_MODE_ERROR                  (SMTP_ERROR_BASE+43)
#define         SMTP_PASSWD_WRONG                       (SMTP_ERROR_BASE+44)
#define         SMTP_SAVE_COMPLETE                      (SMTP_ERROR_BASE+45)
#define         SMTP_CHECK_FOR_OUT_MSGS                 (SMTP_ERROR_BASE+46)
#define         SMTP_MAIL_MOVED_TO_OUTBOX_FOR_SENDING         (SMTP_ERROR_BASE+47)
#endif				/* __SMTP_ERROR_CODES_H_ */
