
/*
 * LibSylph -- E-Mail client library
 * Copyright (C) 1999-2006 Hiroyuki Yamamoto
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __PREFS_ACCOUNT_H__
#define __PREFS_ACCOUNT_H__

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <glib.h>
#include <time.h>
#include "session.h"

typedef struct _UserSettings UserSettings;
typedef struct _ReceiveSettings ReceiveSettings;
typedef struct _SendSettings SendSettings;
typedef struct _AdvancedSettings AdvancedSettings;
typedef struct _PrefsAccount PrefsAccount;

typedef enum {
	ACCOUNT_NAME_MISSING = 1,
	USERID_MISSING,
	PASSWD_MISSING,
	EMAIL_MISSING,
	SMTP_AUTH_TYPE_MISSING,
	RECV_PROTOCOL_MISSING,
	RECV_SERVER_MISSING,
	RECV_SERVER_PORT_MISSING,
	PASSWD_AUTH_TYPE_MISSING,
	RECV_TYPE_MISSING,
	SIZE_LIMIT_MISSING,
	RECENT_MAILS_MISSING,
	SIGNATURE_FILE_MISSING,
	IMAP_DIR_MISSING,
	INTERVAL_MISSING
} ParamMissing;


typedef enum {
	PROTO_POP3,
	PROTO_IMAP4,
	PROTO_INVALID
} RecvProtocol;


typedef enum {
	AUTH_LOGIN = 1,
	AUTH_CRAM_MD5,
	AUTH_APOP
} PasswdAuthType;


typedef enum {
	USER_SETTING = 1,
	SEND_SETTING = 1 << 1,
	RECEIVE_SETTING = 1 << 2,
	ADVANCED_SETTING = 1 << 3,
	SCHEDULED_SETTING = 1 << 4
} SettingType;


typedef enum {
	HEADERS = 1,
	BODY,
	BODY_ATTCH
} RecvType;

typedef enum {
	SMTPAUTH_NO_AUTH = 0,
	SMTPAUTH_LOGIN = 1,
	SMTPAUTH_CRAM_MD5
} SMTPAuthType;


typedef enum {
	EMAIL_TEXT = 1,
	EMAIL_HTML
} EmailType;

typedef enum {
	SEND_IMMEDIATE = 1,
	SEND_NEXT_CONNECTION,
	SEND_ON_REQUEST,
} EmailSending;

typedef enum {
	MMC_CONNECTED = 1,
	MMC_DISCONNECTED,
	MMC_ERROR
} MmcStatus;


struct _UserSettings {
	gchar *account_name;
	gboolean is_default;
	gchar *userid;
	gchar *passwd;
	gboolean remember_passwd;
	gchar *tmp_passwd;
	gchar *email;
	gchar *alias_name;
	Session *session;
	gboolean scheduled_op;
	gboolean cancel;
};

struct _ReceiveSettings {
	RecvProtocol protocol;
	gchar *recv_server;
	gushort port;
	PasswdAuthType passwd_auth_type;
	RecvType recv_type;
	gboolean enable_size_limit;
	gint size_limit;
	gint recent_mails;
	gint last_uid_validity;
	gint first_msgid;
	gint last_msgid;
	gboolean leave_msg;
	gboolean is_not_editable;
	gint num_of_msgs;
};

struct _SendSettings {
	gchar *smtp_server;
	SMTPAuthType smtp_auth_type;
	gushort smtp_port;
	gchar *username;
	gchar *password;
};

typedef enum {
	ACCNT_RX = 1 << 0,
	ACCNT_SEND = 1 << 1,
} AccntStatusFlags;

struct _AdvancedSettings {
	EmailType email_type;
	EmailSending email_sending;
	gboolean include_signature;
	gchar *signature_file;
	gboolean signature_flag;
	gboolean request_read_report;
	gboolean copy_to_own_address;
	gboolean org_in_reply;
	gboolean use_ssl;
	gboolean use_tls;
	gboolean smtp_use_ssl;
	gboolean smtp_use_tls;
	gchar *imap_dir;
	gboolean use_iap_smtp_serv; 
#if CL_USE
	gchar *iap_name;	/* Connectivity Layer iap name */
#endif
	gint smime_security;
	gboolean display_sign_encrypt;
	gboolean display_trust;
	gboolean display_validity;
	AccntStatusFlags account_status;
};


struct _PrefsAccount {
	UserSettings user_settings;
	ReceiveSettings receive_settings;
	SendSettings send_settings;
	AdvancedSettings advanced_settings;
};



PrefsAccount *prefs_account_new(void);

PrefsAccount *prefs_account_open(PrefsAccount * ac_prefs);

gboolean prefs_account_read_config(PrefsAccount * ac_prefs, const gchar * label);
gboolean prefs_account_save_config_all(GSList * account_list);

void prefs_account_free(PrefsAccount * ac_prefs);

#endif				/* __PREFS_ACCOUNT_H__ */
