
/*
 * LibSylph -- E-Mail client library
 * Copyright (C) 1999-2006 Hiroyuki Yamamoto
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __PARSEBODY_H__
#define __PARSEBODY_H__

#define BODY_STRUCT "BODYSTRUCTURE"
#define START_BR '('
#define END_BR ')'
#define MAX_PARA_LEN 128
#define MAX_FIELD_LENGTH 128
#define PARSE_SUCCESS 0
#define PARSE_FAIL -1
#define CAP_CHARSET "CHARSET"
#define CHARSET "charset"
#define CAP_NAME "NAME"
#define NAME "name"
#define CAP_FILENAME "FILENAME"
#define FILENAME "filename"
#define CAP_ATTACHMENT "ATTACHMENT"
#define CAP_INLINE "INLINE"
#define INLINE "inline"
#define BOUNDARY "boundary"
#define TYPE_SEPRTR '/'
#define MESSAGE_TYPE "message"
#define APPLCTN_TYPE "application"
#define IMAGE_TYPE  "image"
#define AUDIO_TYPE  "audio"
#define ALL_FIELDS 6
#define ALTERNATIVE "alternative"
#define RELATED "related"
#define MIXED "mixed"
#define QUOTE '\"'
#define HEAD_CAPTAG "<HEAD"
#define HEAD_TAG "<head"
#define HTML_TAG "<html"
#define HTML_CAPTAG "<HTML"
#define HTML_END_TAG "</html"
#define HTML_END_CAPTAG "</HTML"
#define HEAD_END_CAPTAG "</HEAD"
#define HEAD_END_TAG "</head"
#define STYLE_TAG "<style"
#define STYLE_CAPTAG "<STYLE"
#define BODY_CAPTAG "<BODY"
#define BODY_TAG "<body"
#define END_OF_TAG '>'
#define FONT_STR "\n<!--\nbody{font-family:\"%s\"}\n-->\n"
#define STYLE_STR "\n<style type = \"text/css\">\n<!--\nbody \
{font-family:\"%s\"}\n-->\n</style>\n"
#define HEAD_STYLE_STR "\n<head>\n<style type = \"text/css\">\n<!--\nbody \
{font-family:\"%s\"}\n-->\n</style>\n</head>\n"

static void procmime_parse_body_para(MimeInfo * mimeinfo, gchar ** bodyptr, const
				     gchar * end, const gchar * section_number);
static gint procmime_get_field(MimeInfo * mimeinfo, gint count, gchar ** bodyptr,
			       const gchar * end);
static void procmime_parse_mime_type(const gchar * mime_type,
				     const gchar * sub_type, MimeInfo * mimeinfo);

static MimeInfo *procmime_parse_bodyfields(gchar ** bodyptr, const gchar * end,
					   const gchar * section_number);
static void procmime_parse_multipart(MimeInfo * mimeinfo, gchar ** bodyptr,
				     const gchar * end, const gchar * part_section_number);
static gchar *procmime_get_para_end(gint left_op, gchar * para_ptr, const gchar * end);
static MimeInfo *procmime_parse_section(gchar ** bodyptr, const gchar * end,
					const gchar * section_number);
static void procmime_parse_content_disp(MimeInfo * mimeinfo, const gchar * ptr, const gchar * end);
static MimeInfo *procmime_get_sub(MimeInfo * mimeinfo, gchar * ptr, const gchar * end,
				  const gchar * section_number);
#endif				/* PARSEBODY */
