
/*
 * LibSylph -- E-Mail client library
 * Copyright (C) 1999-2006 Hiroyuki Yamamoto
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef __HTML_TO_TEXT_CONV_H__
#define __HTML_TO_TEXT_CONV_H__

#include "html.h"
#include "codeconv.h"

/**
   This fuction is called to convert the html data to text from given 
   filename and store the out put to the file called filename.conv  
   text     
   @param  filename contains filename of the html data  
   @param  convertedtext contains the output filename  
   @return on successful operation returns OSSO_PACK_OK. Otherwise 
    returns errorcode 
*/

gboolean
html_to_text_converter(const gchar * htmlfilename, const gchar * charset, gchar ** textfile);
/**
   This fuction is called to convert the html data to text  
   @param htmldata contains the html data
   @param  convertedtext contains the text data  
   @return on successful operation returns OSSO_PACK_OK. Otherwise
    returns errorcode
*/
gboolean
html_to_text_convert_buffer(const gchar * htmldata, const gchar * charset, gchar ** convertedtext);

#endif				/* __HTML_TO_TEXT_CONV_H__ */
