
/**
 * This file is part of osso-email-common
 *
 * Copyright (c) 2006 Nokia Corporation.
 * 
 * Contact: Dirk-Jan Binnema <dirk-jan.binnema@nokia.com>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef __ENGINE_ERROR_NO_H_
#define __ENGINE_ERROR_NO_H_

/* engine error codes */

#define ENGINE_ERROR_DEFAULT 0
#define ENGINE_ERROR_BASE 9000
#define ENGINE_ERROR_INVALID_FOLDER (ENGINE_ERROR_BASE +1)
#define ENGINE_ERROR_MSG_FILE_DOES_NOT_EXIST (ENGINE_ERROR_BASE +2)
#define ENGINE_ERROR_FOLDER_MESSAGE_DEL_LIST_FAILED (ENGINE_ERROR_BASE +3)
#define ENGINE_ERROR_INVALID_PROTOCOL (ENGINE_ERROR_BASE +4)
#define ENGINE_ERROR_INVALID_MSGID (ENGINE_ERROR_BASE +5)
#define ENGINE_ERROR_NO_MEM (ENGINE_ERROR_BASE +6)
#define ENGINE_ERROR_FILE_ERROR (ENGINE_ERROR_BASE +7)
#define ENGINE_ERROR_MIME_INVALID (ENGINE_ERROR_BASE +8)
#define ENGINE_ERROR_FILE_IS_NOT_REGULAR_TYPE (ENGINE_ERROR_BASE +9)
#define ENGINE_ERROR_FILE_STAT_FAILED (ENGINE_ERROR_BASE +9)
#define ENGINE_ERROR_NO_FILE_PERM (ENGINE_ERROR_BASE +10)
#define ENGINE_ERROR_NULL_SUB_MIME  (ENGINE_ERROR_BASE +11)
#define ENGINE_ERROR_NULL_PART_INFO (ENGINE_ERROR_BASE +12)
#define ENGINE_ERROR_INVALID_FILE_CONTENT (ENGINE_ERROR_BASE +13)
#define ENGINE_ERROR_PARSE_FAIL (ENGINE_ERROR_BASE +14)
#define ENGINE_ERROR_FILE_NOT_FOUND (ENGINE_ERROR_BASE +15)
#define ENGINE_ERROR_INVALID_PARAM (ENGINE_ERROR_BASE +16)
#define ENGINE_ERROR_NO_LOCAL_COPY (ENGINE_ERROR_BASE +17)
#define ENGINE_ERROR_OUT_FILE (ENGINE_ERROR_BASE +18)
#define ENGINE_ERROR_FILE_CONTENTS (ENGINE_ERROR_BASE +19)
#define ENGINE_ERROR_ATTACH_DOWNLOAD_ERROR (ENGINE_ERROR_BASE +20)
#define ENGINE_ERROR_ACCOUNT_NOT_FOUND (ENGINE_ERROR_BASE +21)
#define ENGINE_ERROR_INLINE_MESSAGE_FILE_ATTACH (ENGINE_ERROR_BASE +22)
#define ENGINE_ERROR_FOLDER_INIT (ENGINE_ERROR_BASE +23)
#define ENGINE_ERROR_ACCOUNT_INIT (ENGINE_ERROR_BASE +24)
#define ENGINE_ERROR_REG_FAILED (ENGINE_ERROR_BASE +25)
#define ENGINE_ERROR_CHRSET_CONVERT (ENGINE_ERROR_BASE + 26)
#define ENGINE_ERROR_IMAP_MSG_DELETE (ENGINE_ERROR_BASE + 27)
#define ENGINE_ERROR_CONNECT_SERVER (ENGINE_ERROR_BASE + 28)
#define ENGINE_ERROR_OPERATION (ENGINE_ERROR_BASE + 29)
#define ENGINE_ERROR_SSL_INIT_FAILED (ENGINE_ERROR_BASE +30)
#define ENGINE_ERROR_NO_FOLDER_PERM (ENGINE_ERROR_BASE +31)
#define ENGINE_ERROR_FOLDER_INIT_LIST (ENGINE_ERROR_BASE +32)
#define ENGINE_SIZE_ERROR (ENGINE_ERROR_BASE +33)
#define ENGINE_ERROR_IMAP_SYNC (ENGINE_ERROR_BASE +34)
#define ENGINE_ERROR_CL_INIT_FAILED (ENGINE_ERROR_BASE +35)
#define ENGINE_ERROR_MMC_HLR_INIT_FAILED (ENGINE_ERROR_BASE +36)
#define ENGINE_ERROR_SMIME_INIT_FAILED (ENGINE_ERROR_BASE + 37)
#define ENGINE_ERROR_AL_INIT_FAILED (ENGINE_ERROR_BASE + 38)
#define ENGINE_ERROR_POP_MSG_DELETE (ENGINE_ERROR_BASE + 39)
#define ENGINE_ERROR_IAP_CONNECT (ENGINE_ERROR_BASE + 40)
/* Flash Full Error code */
#define ENGINE_ERROR_DEVICE_MEMORY_FULL (ENGINE_ERROR_BASE + 41)
#define ENGINE_STATUS_SEND_RECV_CANCEL (ENGINE_ERROR_BASE + 42)
#define ENGINE_RCPT_LIST_INVALID (ENGINE_ERROR_BASE + 43)
#define ENGINE_SOCKET_TIME_OUT (ENGINE_ERROR_BASE + 44)


/* IMAP related errors */
#define IMAP_MSG_UID_LEN 15
#define IMAP_SUCCESS    0
#define IMAP_FAIL -1
#define IMAP_ERROR_BASE 3000
#define IMAP_PARAMETER_MISSING (IMAP_ERROR_BASE +1)
#define IMAP_CONNECT_SERVER_ERROR (IMAP_ERROR_BASE +2)
#define IMAP_UID_FETCH_ERROR (IMAP_ERROR_BASE +3)
#define IMAP_INBOX_SELECT_ERROR (IMAP_ERROR_BASE +4)
#define IMAP_CLOSE_ERROR (IMAP_ERROR_BASE +5)
#define IMAP_FLAG_SET_ERROR (IMAP_ERROR_BASE +6)
#define IMAP_EXPUNGE_ERROR (IMAP_ERROR_BASE +7)
#define IMAP_MSG_FETCH_ERROR (IMAP_ERROR_BASE +8)
#define IMAP_SOCKET (IMAP_ERROR_BASE +9)
#define IMAP_ERROR (IMAP_ERROR_BASE +10)
#define IMAP_AUTHFAIL   (IMAP_ERROR_BASE +11)
#define IMAP_PROTOCOL   (IMAP_ERROR_BASE +12)
#define IMAP_SYNTAX     (IMAP_ERROR_BASE +13)
#define IMAP_IOERR      (IMAP_ERROR_BASE +14)
#define IMAP_INVALID_UID        (IMAP_ERROR_BASE +15)
#define IMAP_MSG_SIZE_EXCEED_ERROR      (IMAP_ERROR_BASE +16)
#define IMAP_INVALID_MSGID_ERROR        (IMAP_ERROR_BASE +17)
#define IMAP_MAIL_ALREADY_DOWNLOADED    (IMAP_ERROR_BASE +18)
#define IMAP_MESSAGE_NOT_AVAILABLE_IN_SERVER    (IMAP_ERROR_BASE +19)
#define IMAP_NO_HEADERS_DOWNLOADED      (IMAP_ERROR_BASE +20)
#define IMAP_SERVER_NOT_SUPPORT_ERROR (IMAP_ERROR_BASE +21)
#define IMAP_INVALID_RECENT_MAIL_SETTING (IMAP_ERROR_BASE +22)
#define IMAP_HEADERS_DOWNLOAD_ERROR (IMAP_ERROR_BASE +23)
#define IMAP_HEADER_FETCH_ERROR (IMAP_ERROR_BASE +24)
#define IMAP_NOT_ABLE_TO_ALLOCATE_MEMORY_ERROR (IMAP_ERROR_BASE +25)
#define IMAP_FOLDER_NOT_FOUND_ERROR (IMAP_ERROR_BASE +25)
#define IMAP_CONNECT_SERVER_SUCCESS (IMAP_ERROR_BASE +26)
#define IMAP_STARTTLS_ERROR (IMAP_ERROR_BASE +27)
#define IMAP_REPOP_ERROR (IMAP_ERROR_BASE +28)
#define IMAP_PROGRESS (IMAP_ERROR_BASE +29)
#define IMAP_COMPLETE (IMAP_ERROR_BASE +30)
#define IMAP_MSG_DOWNLOAD (IMAP_ERROR_BASE +31)
#define IMAP_SERVER_SYNC_ERROR (IMAP_ERROR_BASE +32)
#define IMAP_EMAIL_ATTACH_NOT_AVAILABLE_ERROR (IMAP_ERROR_BASE +33)
#define IMAP_START (IMAP_ERROR_BASE +34)
#define IMAP_MAIL_BOX_LOCK_LOST (IMAP_ERROR_BASE +35)
#define IMAP_PASSWD_FAIL (IMAP_ERROR_BASE +36)
#define IMAP_CONNECTION_FLIGHT_MODE (IMAP_ERROR_BASE +37)
#define IMAP_PASSWD_INCORRECT (IMAP_ERROR_BASE +38)

/* POP related errors */


/* SMTP related errors */ 

#endif				/* __ENGINE_ERROR_NO_H_ */
