
/**
 * This file is part of osso-email-common
 *
 * Copyright (c) 2006 Nokia Corporation.
 * 
 * Contact: Dirk-Jan Binnema <dirk-jan.binnema@nokia.com>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef OSSO_EMAIL_INTERNAL_INTERFACES_H
#define OSSO_EMAIL_INTERNAL_INTERFACES_H

#ifdef __cplusplus
extern "C" {
#endif


enum operation_type {
        OSSO_EMAIL_HOME = 0,
        OSSO_EMAIL_SEND_RECV = 1,
        OSSO_EMAIL_FILE_MGR,
        OSSO_EMAIL_URL,
        OSSO_EMAIL_MAIL_TO,
        OSSO_TASKNAV_OPEN_MSG,
        OSSO_TASKNAV_OPEN_NEW_MSG,
        OSSO_TASKNAV_OPEN_INBOX,
        OSSO_TASKNAV_DELETE_MSG
};

#define FILE_MGR_ARG       "--files="
#define URL_ARG            "--url="
#define MAIL_TO_ARG        "--to="
#define OPEN_MSG_ARG       "--openmsg="
#define UI_WINDOW_REG  "--ui_window_reg="


enum osso_email_state {
        OSSO_STATE_UN_INIT = 1, 	/* No Initialisation */
	OSSO_STATE_INIT_LIMITED,        /* Only engine is up and running */
	OSSO_STATE_UI_INIT_PROGRESS,    /* UI init happening */
	OSSO_STATE_INIT_COMPLETE,       /* Both engine and UI is UP */
};

enum {
        SIGNAL_EXIT,
        SIGNAL_SHUTDOWN_IND,
        SIGNAL_SAVE_UNSAVED_DATA_IND,
        SIGNAL_MEMORY_LOW_IND,
        SIGNAL_SYSTEM_INACTIVITY_IND
};

typedef enum {
        LIST_FOLDER_NONE,
        LIST_FOLDER_ADD,
        LIST_FOLDER_BIN,
        LIST_FOLDER_UPDATE,
        LIST_FOLDER_DEL
} FolderListType;

#define BACKUP_START_EVENT "backup_start_handle"


#ifdef __cplusplus
}
#endif
#endif				/* OSSO_EMAIL_INTERNAL_INTERFACES_H ends here */
