
/**
 * This file is part of osso-email-common
 *
 * Copyright (c) 2006 Nokia Corporation.
 * 
 * Contact: Dirk-Jan Binnema <dirk-jan.binnema@nokia.com>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef OSSO_EMAIL_GCONF_H
#define OSSO_EMAIL_GCONF_H

#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include <libosso.h>
#include <log-functions.h>

#ifdef __cplusplus
extern "C" {
#endif


/** Email Gconf related configuration data */

#define EMAIL_GCONF_PATH			"/apps/osso/tnemail"
#define EMAIL_SYS_ALERT_VOL	"/apps/osso/sound/system_alert_volume"
	
#define EMAIL_GCONF_UNREAD_MAIL_COUNT	EMAIL_GCONF_PATH"/UnReadMails"
#define EMAIL_GCONF_CHANGE_STATUS       EMAIL_GCONF_PATH"/ChangeStatus"
#define EMAIL_GCONF_SENDRECV_STATUS     EMAIL_GCONF_PATH"/SendRecvStatus"

#define SEND_RECV_NO_ACCT               0
#define SEND_RECV_DONE                  1
#define SEND_RECV_PROGRESS              2

#define EMAIL_GCONF_UNREAD_MAIL1_MSGID		EMAIL_GCONF_PATH"/Mail1/MsgId"
#define EMAIL_GCONF_UNREAD_MAIL1_FROM		EMAIL_GCONF_PATH"/Mail1/From"
#define EMAIL_GCONF_UNREAD_MAIL1_SUBJECT	EMAIL_GCONF_PATH"/Mail1/Subject"
#define EMAIL_GCONF_UNREAD_MAIL1_TIME		EMAIL_GCONF_PATH"/Mail1/time"
#define EMAIL_GCONF_UNREAD_MAIL1_HAS_ATTACH	EMAIL_GCONF_PATH"/Mail1/Attachment"

#define EMAIL_GCONF_UNREAD_MAIL2_MSGID		EMAIL_GCONF_PATH"/Mail2/MsgId"
#define EMAIL_GCONF_UNREAD_MAIL2_FROM		EMAIL_GCONF_PATH"/Mail2/From"
#define EMAIL_GCONF_UNREAD_MAIL2_SUBJECT	EMAIL_GCONF_PATH"/Mail2/Subject"
#define EMAIL_GCONF_UNREAD_MAIL2_TIME		EMAIL_GCONF_PATH"/Mail2/time"
#define EMAIL_GCONF_UNREAD_MAIL2_HAS_ATTACH	EMAIL_GCONF_PATH"/Mail2/Attachment"

#define EMAIL_GCONF_UNREAD_MAIL3_MSGID		EMAIL_GCONF_PATH"/Mail3/MsgId"
#define EMAIL_GCONF_UNREAD_MAIL3_FROM		EMAIL_GCONF_PATH"/Mail3/From"
#define EMAIL_GCONF_UNREAD_MAIL3_SUBJECT	EMAIL_GCONF_PATH"/Mail3/Subject"
#define EMAIL_GCONF_UNREAD_MAIL3_TIME		EMAIL_GCONF_PATH"/Mail3/time"
#define EMAIL_GCONF_UNREAD_MAIL3_HAS_ATTACH	EMAIL_GCONF_PATH"/Mail3/Attachment"

#define EMAIL_GCONF_UNREAD_MAIL4_MSGID		EMAIL_GCONF_PATH"/Mail4/MsgId"
#define EMAIL_GCONF_UNREAD_MAIL4_FROM		EMAIL_GCONF_PATH"/Mail4/From"
#define EMAIL_GCONF_UNREAD_MAIL4_SUBJECT	EMAIL_GCONF_PATH"/Mail4/Subject"
#define EMAIL_GCONF_UNREAD_MAIL4_TIME		EMAIL_GCONF_PATH"/Mail4/time"
#define EMAIL_GCONF_UNREAD_MAIL4_HAS_ATTACH	EMAIL_GCONF_PATH"/Mail4/Attachment"

#define EMAIL_GCONF_UNREAD_MAIL5_MSGID		EMAIL_GCONF_PATH"/Mail5/MsgId"
#define EMAIL_GCONF_UNREAD_MAIL5_FROM		EMAIL_GCONF_PATH"/Mail5/From"
#define EMAIL_GCONF_UNREAD_MAIL5_SUBJECT	EMAIL_GCONF_PATH"/Mail5/Subject"
#define EMAIL_GCONF_UNREAD_MAIL5_TIME		EMAIL_GCONF_PATH"/Mail5/time"
#define EMAIL_GCONF_UNREAD_MAIL5_HAS_ATTACH	EMAIL_GCONF_PATH"/Mail5/Attachment"

#define EMAIL_GCONF_UI_CLOSED		        EMAIL_GCONF_PATH"/UI/Status"
	/*scheduling related gconf values*/
#define EMAIL_SCHEDULING_PATH			"/apps/osso/emailscheduling"
#define EMAIL_SCHEDULING_INTERVAL			"/apps/osso/emailscheduling/schedulingInterval"
#define EMAIL_SCHEDULING_VIA_WLAN			"/apps/osso/emailscheduling/schedulingViaWlan"
#define EMAIL_ALARM_ID			"/apps/osso/emailalarm/alarmid"

#define EMAIL_RECV_MAILS_PROGRESS		"/apps/osso/email/"
#define EMAIL_RECV_MAILS_PROGRESS_CUR		"/apps/osso/email/cur_recv_mails"
#define EMAIL_RECV_MAILS_PROGRESS_TOTAL		"/apps/osso/email/total_mails"
#define EMAIL_SCHEDULING_PROGRESS	        "/apps/osso/email_auto_retrieve/autoRetrieving"
#define EMAIL_PLAY_SOUND_ON_NEW_MAIL		"/apps/osso/email/play_sound_on_new_mail"

#define EMAIL_OPEN_NOTIFICATIONS         "/apps/osso/email/open_notifications"


/* Get functions */
#define osso_email_gconf_get_mailid(k,v) osso_email_gconf_get_str(k,v)
#define osso_email_gconf_get_from(k,v) osso_email_gconf_get_str(k,v)
#define osso_email_gconf_get_subject(k,v) osso_email_gconf_get_str(k,v)
#define osso_email_gconf_get_time(k,v) osso_email_gconf_get_float(k,v)
#define osso_email_gconf_get_has_attachment(k,v) osso_email_gconf_get_bool(k,v)
#define osso_email_gconf_get_unread_mails(k,v) osso_email_gconf_get_int(k,v)
#define osso_email_gconf_get_change_status(k,v) osso_email_gconf_get_bool(k,v)
#define osso_email_gconf_get_sendrecv_status(k,v) osso_email_gconf_get_int(k,v)

#define osso_email_gconf_get_system_alert_(k,v) osso_email_gconf_get_int(k,v)
/* Set functions */
#define osso_email_gconf_set_mailid(k,v) osso_email_gconf_set_str(k,v)
#define osso_email_gconf_set_from(k,v) osso_email_gconf_set_str(k,v)
#define osso_email_gconf_set_subject(k,v) osso_email_gconf_set_str(k,v)
#define osso_email_gconf_set_time(k,v) osso_email_gconf_set_float(k,v)
#define osso_email_gconf_set_has_attachment(k,v) osso_email_gconf_set_bool(k,v)
#define osso_email_gconf_set_unread_mails(k,v) osso_email_gconf_set_int(k,v)
#define osso_email_gconf_set_change_status(k,v) osso_email_gconf_set_bool(k,v)
#define osso_email_gconf_set_sendrecv_status(k,v) osso_email_gconf_set_int(k,v)

gboolean osso_email_gconf_init(int argc, char **argv);
GConfClient *osso_email_gconf_init_default_client(void);

gboolean osso_email_gconf_get_bool(gchar * key, gboolean * output);
gboolean osso_email_gconf_set_bool(gchar * key, gboolean val);
gboolean osso_email_gconf_get_str(gchar * key, gchar ** output);
gboolean osso_email_gconf_set_str(gchar * key, gchar * input);
gboolean osso_email_gconf_get_int(gchar * key, gint * output);
gboolean osso_email_gconf_set_int(gchar * key, gint val);
gboolean osso_email_gconf_get_float(gchar * key, gfloat * output);
gboolean osso_email_gconf_set_float(gchar * key, gfloat val);
gboolean osso_email_gconf_get_int_list(gchar * key, GSList **output);
gboolean osso_email_gconf_set_int_list(gchar * key, GSList *val);
gboolean osso_email_gconf_unset(gchar * key);

#ifdef __cplusplus
}
#endif
#endif				/* OSSO_EMAIL_GCONF_H ends here */
