
/**
 * This file is part of osso-email-common
 *
 * Copyright (c) 2006 Nokia Corporation.
 * 
 * Contact: Dirk-Jan Binnema <dirk-jan.binnema@nokia.com>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#include "email_gconf.h"

gboolean osso_email_gconf_init(int argc, char **argv)
{
	GError *error = NULL;
	if (!gconf_init(argc, argv, &error)) {
		osso_log(LOG_ERR, "Error in Gconf init = %s  \n", error->message);
		g_error_free(error);
		return FALSE;
	}
	g_type_init();
	return TRUE;
}

GConfClient *osso_email_gconf_init_default_client(void)
{
	GConfClient *client = NULL;
	if ((client = gconf_client_get_default()) == NULL) {
		osso_log(LOG_ERR, "[%s]: Gconf Client get fail \n");
	}
	return client;
}

gboolean osso_email_gconf_set_bool(gchar * key, gboolean val)
{
	GConfClient *client = NULL;

	if (key == NULL) {
		osso_log(LOG_ERR, "[%s]: Invalid Input arguments \n", __FUNCTION__);
		return FALSE;
	}

	if ((client = osso_email_gconf_init_default_client()) == NULL) {
		return FALSE;
	}
	gconf_client_set_bool(client, key, val, NULL);
	return TRUE;
}

gboolean osso_email_gconf_get_bool(gchar * key, gboolean * output)
{
	GError *error = NULL;
	GConfClient *client = NULL;

	if ((key == NULL) || (output == NULL)) {
		osso_log(LOG_ERR, "[%s]: Invalid Input arguments \n", __FUNCTION__);
		return FALSE;
	}

	if ((client = osso_email_gconf_init_default_client()) == NULL) {
		return FALSE;
	}

	*output = gconf_client_get_bool(client, key, &error);

	if (error != NULL) {
		osso_log(LOG_ERR, "Error %s for value %s \n", error->message, key);
		g_error_free(error);
		return FALSE;
	}
	return TRUE;
}

gboolean osso_email_gconf_set_str(gchar * key, gchar * input)
{
	GConfClient *client = NULL;

	if ((key == NULL) || (input == NULL)) {
		osso_log(LOG_ERR, "[%s]: Invalid Input arguments \n", __FUNCTION__);
		return FALSE;
	}

	if ((client = osso_email_gconf_init_default_client()) == NULL) {
		return FALSE;
	}
	gconf_client_set_string(client, key, input, NULL);
	return TRUE;
}

gboolean osso_email_gconf_get_str(gchar * key, gchar ** output)
{
	GError *error = NULL;
	GConfClient *client = NULL;

	if ((key == NULL) || (output == NULL)) {
		osso_log(LOG_ERR, "[%s]: Invalid Input arguments \n", __FUNCTION__);
		return FALSE;
	}
	if ((client = osso_email_gconf_init_default_client()) == NULL) {
		return FALSE;
	}

	*output = gconf_client_get_string(client, key, &error);

	if (error != NULL) {
		osso_log(LOG_ERR, "Error %s for value %s \n", error->message, key);
		g_error_free(error);
		return FALSE;
	}
	return TRUE;
}

gboolean osso_email_gconf_set_int(gchar * key, gint val)
{
	GConfClient *client = NULL;

	if (key == NULL) {
		osso_log(LOG_ERR, "[%s]: Invalid Input arguments \n", __FUNCTION__);
		return FALSE;
	}

	if ((client = osso_email_gconf_init_default_client()) == NULL) {
		return FALSE;
	}
	gconf_client_set_int(client, key, val, NULL);
	return TRUE;
}

gboolean osso_email_gconf_get_int(gchar * key, gint * output)
{
	GError *error = NULL;
	GConfClient *client = NULL;

	if ((key == NULL) || (output == NULL)) {
		osso_log(LOG_ERR, "[%s]: Invalid Input arguments \n", __FUNCTION__);
		return FALSE;
	}

	if ((client = osso_email_gconf_init_default_client()) == NULL) {
		return FALSE;
	}
	*output = gconf_client_get_int(client, key, &error);
	if (error != NULL) {
		osso_log(LOG_ERR, "Error %s for value %s \n", error->message, key);
		g_error_free(error);
		return FALSE;
	}
	return TRUE;
}

gboolean osso_email_gconf_set_float(gchar * key, gfloat val)
{
	GConfClient *client = NULL;

	if (key == NULL) {
		osso_log(LOG_ERR, "[%s]: Invalid Input arguments \n", __FUNCTION__);
		return FALSE;
	}

	if ((client = osso_email_gconf_init_default_client()) == NULL) {
		return FALSE;
	}
	gconf_client_set_float(client, key, val, NULL);
	return TRUE;
}

gboolean osso_email_gconf_get_float(gchar * key, gfloat * output)
{
	GError *error = NULL;
	GConfClient *client = NULL;

	if ((key == NULL) || (output == NULL)) {
		osso_log(LOG_ERR, "[%s]: Invalid Input arguments \n", __FUNCTION__);
		return FALSE;
	}

	if ((client = osso_email_gconf_init_default_client()) == NULL) {
		return FALSE;
	}
	*output = gconf_client_get_float(client, key, &error);
	if (error != NULL) {
		osso_log(LOG_ERR, "Error %s for value %s \n", error->message, key);
		g_error_free(error);
		return FALSE;
	}
	return TRUE;
}

gboolean osso_email_gconf_set_int_list(gchar * key, GSList *val)
{
	GConfClient *client = NULL;

	if (key == NULL) {
		osso_log(LOG_ERR, "[%s]: Invalid Input arguments \n", __FUNCTION__);
		return FALSE;
	}

	if ((client = osso_email_gconf_init_default_client()) == NULL) {
		return FALSE;
	}
	gconf_client_set_list(client, key, GCONF_VALUE_INT, val, NULL);
	return TRUE;
}

gboolean osso_email_gconf_get_int_list(gchar * key, GSList **output)
{
        GError *error = NULL;
	GConfClient *client = NULL;

	if ((key == NULL) || (output == NULL)) {
		osso_log(LOG_ERR, "[%s]: Invalid Input arguments \n", __FUNCTION__);
		return FALSE;
	}

	if ((client = osso_email_gconf_init_default_client()) == NULL) {
		return FALSE;
	}
	*output = gconf_client_get_list(client, key, GCONF_VALUE_INT, &error);
	if (error != NULL) {
		osso_log(LOG_ERR, "Error %s for value %s \n", error->message, key);
		g_error_free(error);
		return FALSE;
	}
	return TRUE;
}

gboolean osso_email_gconf_unset(gchar * key)
{
	GError *error = NULL;
	GConfClient *client = NULL;

	if (key == NULL) {
		osso_log(LOG_ERR, "[%s]: Invalid Input arguments \n", __FUNCTION__);
	}

	if ((client = osso_email_gconf_init_default_client()) == NULL) {
		return FALSE;
	}

	gconf_client_unset(client, key, &error);

	return TRUE;
}
