
/*
 * LibSylph -- E-Mail client library
 * Copyright (C) 1999-2006 Hiroyuki Yamamoto
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __DEFS_H__
#define __DEFS_H__

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#if HAVE_PATHS_H
#  include <paths.h>
#endif

#if HAVE_SYS_PARAM_H
#  include <sys/param.h>
#endif
#define STANDARD_PATH (g_get_home_dir())
#define STANDARD_PATH_LEN (strlen(g_get_home_dir()))
#define PATH_OSSO        "/.osso/"
#define CONFIG_FILE_PATH    "/apps/email/settings"
#define REST_CONFIG_FILE_PATH    "/.osso/osso-email"
#define APPLN_PATH "apps"
#define EMAIL_PATH "email"
#define VAR_PATH  "/var/tmp"

#define SENT_DIR		"Sent"
#define OUTBOX_DIR		"Outbox"
#define INBOX_DIR		"Inbox"
#define DRAFT_DIR		"Draft"
#define RC_DIR			"email"
#define MAIL			"Mail"
#define IMAP_CACHE_DIR	"imapcache"
#define MIME_TMP_DIR	"mimetmp"
#define COMMON_RC		"sylpheedrc"
#define ACCOUNT_RC		"accountrc"
#define FILTER_RC		"filterrc"
#define UI_SETTINGS_RC    "email_settings.xml"
#define TMP_DIR			"tmp"
#define MARK_FILE		".sylpheed_mark"
#define MARK_VERSION		2
#define SECTION_SEPARATOR '.'
#define DEC_SUFFIX "dec"
#define MIME_SUFFIX "mhdr"
#define PURGE_SUFFIX "prg"
#define ATTACHMENT "attachment"
#define MHTML_EXTENSION "mime"
#define HEAD "0"
#define MSGID_SEPARATOR '^'
#define MSG_BODY_SEC "1"
#define MSG_DEL_FILE "msgdelfile.txt"
#define MSG_REM_FILE "msgremfile.txt"
#define SUB_SUFFIX "sub"
#define ATTACHMENTS "attachments"
#define SPACE_CHAR ' '
#define MSG_BODY '1'
#define SECTION_LOC 2
#define BODY_SEC_LOC 1

#define ACCOUNT_NAME_LEN 256
#define FOLDER_NAME_LEN 256
#define MSGNUM_LEN 8
#define MSG_ID_LEN (ACCOUNT_NAME_LEN + FOLDER_NAME_LEN + MSGNUM_LEN +2)

#define AT_THE_RATE '@'
#define DIR_SEPRTR '/'

#define ARCHIVE "Archive"
#define R_ARCHIVE ".archive"
#define MMC_PATH "/media/mmc1"
#define XML_CACHE "cache.xml"
#define ARCHIVE_COPY_PREFIX "^Archive^"
#define DEFAULT "default"
#define DOT     '.'
#define MSG_HDR  "hdr"

#define NUM_MAILS 100
#define MAX_TN_MAILS 5

#define CA_LIST "CAfile.pem"
#define CERT_DIR "mail_client_cert"

#define  DBUS_UNIX_SOCKET_CLNT_PATH 	  "unix:abstract=/tmp/ossomail/8877"
#define  DBUS_UNIX_SOCKET_SERV_PATH 	  "unix:abstract=/tmp/ossomail/7788"
#define  DBUS_UNIX_SOCKET_SEND_RECV_PATH  "unix:abstract=/tmp/ossomail/6677"
#define  EMAIL_SERVICE	"osso_email"
#define  EMAIL_UI_PROCESS "/usr/bin/ossoemail"
#define   NEW_MAIL_WAV_FILE   "/usr/share/sounds/ui-new_email.wav"

#define BUFFSIZE			8192

#define FLAG_MSG_READ 253	/*to unset unread bit 1111 1101 */

#ifndef MAXPATHLEN
#  define MAXPATHLEN			4095
#endif

#define MAX_HISTORY_SIZE		16

#define UI_REFRESH_INTERVAL              50000	/* usec */

#define FOLDER_LIST              "folderlist.xml"
#define MESSAGE_LIST              "messagelist.txt"
#define SEEN_LIST                 "seenlist.txt"
/*TBD These things should be removed later */
#define	TEMPLATE_DIR	"templates"
#define	DEFAULT_BROWSER_CMD "mozilla -remote 'openURL(%s, new-window)'"

#define MAX_SUBJ_LEN	 255

#define MULTIPART_RELATED "multipart/related"

#define MULTIPART_ALTERNATIVE "multipart/alternative"

#define MULTIPART_MIXED "multipart/mixed"

#define MULTIPART_REPORT "multipart/report"

#define MULTIPART_MESSAGE "message/rfc822"

#define SIGNED  "multipart/signed"

#define ENCR    "pkcs7"

#define ENCR7   "PKCS7"


#define HEADER_SECTION "0"

#define MIME_VERSION "MIME-Version"

#define DATE_START ';'

#define UID_EXT   "uidl"
#define DEFAULT_CHARSET "ISO-8859-1"
typedef enum {
	FOLDER_OP_NONE,
	FOLDER_OP_DEL,
	FOLDER_OP_COPY,
	FOLDER_OP_MOVE
} FolderOpernType;

#ifndef VERSION
#define VERSION ""
#endif                          /*VERSION */

#define PROG_VERSION            "OSSO Email, version " VERSION

#endif				/* __DEFS_H__ */
