
/**
 * This file is part of osso-email-common
 *
 * Copyright (c) 2006 Nokia Corporation.
 * 
 * Contact: Dirk-Jan Binnema <dirk-jan.binnema@nokia.com>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef	__CALLBACKS_H__
#define	__CALLBACKS_H__

#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-volume-monitor.h>
#include <libgnomevfs/gnome-vfs-volume.h>

#include "prefs_account.h"
#include "common.h"
#include "procmsg.h"
#include "procmime.h"
#include "iap_confserv.h"

typedef struct _SmtpCallback SmtpCallback;
typedef struct _Pop3Callback Pop3Callback;
typedef struct _Imap4Callback Imap4Callback;
typedef struct _AcctMgmtCallback AcctMgmtCallback;
typedef struct _EmailMgrCallback EmailMgrCallback;
typedef struct _MmcHlrCallback MmcHlrCallback;
typedef struct _AlCallback AlCallback;


struct _SmtpCallback {
	gint(*smtp_param_value_missing_cb) (const ParamMissing param_number);
	gint(*smtp_set_msg_cb) (const gint msg_number,
				const gchar * ipaddr, const gchar * acc_name);
	gint(*smtp_set_percentage_cb) (const gint percent);
	gint(*smtp_update_folder_view_cb) (MsgHeader * msgheader, gint operation, gboolean status);
	gint(*smtp_update_outbox_mail_count) (const gint totalcount, const gint mailssent);
	gint(*smtp_send_complete_cb) (void);
#ifdef CL_USE
	const IapInfo * (*smtp_get_iap_conf_info) (const gchar *iapname);
#endif
};


struct _Pop3Callback {
	gint(*pop3_param_value_missing_cb) (ParamMissing param_number);
	gint(*pop3_set_percentage_cb) (gint percent);
	gint(*pop3_recv_list_cb) (GSList * msg_list);
	gint(*pop3_delete_list_cb) (GSList * msg_list);
	gint(*pop3_recv_complete_cb) (void);
	gint(*pop3_recv_body_complete_cb) (MimeInfo * mimeinfo,
					   const gchar * msgid, gboolean remote_copy);
	gint(*pop3_send_progress_cb) (gint msg_number, const gchar * format, ...);
	 gint(*pop3_set_msg_cb) (gint msg_number, const gchar * format, ...);
};

struct _Imap4Callback {
	gint(*imap4_param_value_missing_cb) (ParamMissing param_number);
	gint(*imap4_msg_headers_cb) (GSList * msg_header_list);
	gint(*imap4_del_list_cb) (GSList * del_list);
	gint(*imap4_set_msg_cb) (gint msg_number, const gchar * format, ...);
};

struct _AcctMgmtCallback {
	gint(*acct_error_code_cb) (gint error_code);
};
struct _MmcHlrCallback {
	gint(*mmc_hlr_volume_mounted_cb) (GnomeVFSVolumeMonitor *
					  volume_monitor, GnomeVFSVolume * volume);
	gint(*mmc_hlr_volume_unmounted_cb) (GnomeVFSVolumeMonitor *
					    volume_monitor, GnomeVFSVolume * volume);
};
struct _AlCallback {
	gint(*al_error_code_cb) (gint error_code);
	gint(*al_folder_list_cb) (gint list_type, const GSList * msg_list);
	gint(*al_recv_attachment_cb) (const MsgInfo * msg_info, gint att_tag);
	gint(*al_folder_msg_cb) (gint msg_number, const gchar * format, ...);
};

struct _EmailMgrCallback {
	gint(*email_mgr_update_outbox_status_cb) (void);
	gint(*email_mgr_tasknav_send_recv_focus_cb) (guint status);
	void (*email_mgr_update_scheduling) (void);
	 gint(*email_mgr_statesave_cb) (gchar ** statesaveinfo, gint operation);
	 gboolean(*email_mgr_disable_timer) (void);
	void (*email_mgr_quit_loop) (void);
};
/* Callback function used for sending engine error code to UI */
gint(*engine_error_code_cb) (gint error_code);

#endif				/* End __CALLBACKS_H__ */
