
/*
 * LibSylph -- E-Mail client library
 * Copyright (C) 1999-2006 Hiroyuki Yamamoto
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __ACCOUNT_H__
#define __ACCOUNT_H__

#include <glib.h>
#include "prefs_account.h"
#include "callbacks.h"

#define PREFSBUFSIZE		1024

/* Account module returning error codes  starts with 4000 */
#define AC_OK   0

#define	ACCOUNT_ERROR_BASE		4000
#define	ACCOUNT_RC_FILE_NOT_EXIST	4001
#define	ACOUNT_RC_FILE_READ_FAIL	4002
#define	ACCOUNT_PREFS_ACCOUNT_LIST_NULL	4003
#define	ACCOUNT_PREFS_ACCOUNT_NOT_EXIST	4004
#define	ACCOUNT_PREFS_ACCOUNT_MEM_FAIL	4005
#define	ACCOUNT_INVALID_ACCOUNT_NAME	4006
#define	ACCOUNT_EMAIL_NULL		4007
#define	ACCOUNT_PROTOCOL_INVALID	4008
#define	ACCOUNT_RECV_SERVER_NULL	4009
#define	ACCOUNT_PASSWD_AUTH_TYPE_INVALID	4010
#define	ACCOUNT_RECV_TYPE_INVALID	4011
#define	ACCOUNT_SMTP_SERVER_NULL	4012
#define	ACCOUNT_SMTP_AUTH_TYPE_INVALID	4013
#define	ACCOUNT_EMAIL_TYPE_INVALID	4014
#define	ACCOUNT_INVALID_AGUMENT		4015
#define	ACCOUNT_CALLBACK_NOT_REGISTER   4016

#define AC_DEFAULT       "default"
#define AC_DEFAULT_EMAIL "default@default.com"
#define AC_DEFAULT_PORT  143

#define ACCOUNT_NAME_MAX_LEN  64

#define ACCT_MGMT_ERROR_CB(errorcode)                            \
{                                                                \
  if (errorcode) {                                               \
    if((acct_mgmt_cb != NULL) && (acct_mgmt_cb->acct_error_code_cb != NULL)) { \
       acct_mgmt_cb->acct_error_code_cb(errorcode);              \
    }                                                            \
  }                                                              \
}

#define ACCNT_SET_FLAGS(accnt, flags)  \
{ (accnt->advanced_settings.account_status) |= (flags); }

#define ACCNT_RESET_FLAGS(accnt, flags)	\
{ (accnt->advanced_settings.account_status) &= ~(flags); }

gint account_init_list(void);

gint account_init(AcctMgmtCallback * acct_cb);

gint account_get_list(GSList ** account_name_list);

gboolean account_get_settings(const gchar * account_name,
			      const SettingType type, PrefsAccount ** prefs_account);

PrefsAccount *account_get_account(const gchar * account_name);

PrefsAccount *account_get_account_cb(const gchar * account_name);

gboolean account_set_settings(const gchar * account_name,
			      const SettingType type, PrefsAccount * prefs_account);

gboolean account_delete(const gchar * account_name);

gboolean account_rename(const gchar * old_name, const gchar * new_name);

PrefsAccount *account_get_default_account(void);

gboolean account_free_account(PrefsAccount * ac_prefs);

gboolean account_free_list(void);

gboolean account_display_list(void);

gboolean account_cleanup(void);

PrefsAccount *account_get_dummy_account(void);

gboolean account_update_list(void);

gchar *account_get_default_account_name(void);

gboolean account_check_for_valid_account(const gchar * account_name);
/**
  This function returns the account list to the caller 
  @return  account_list     list of accounts.This should not be 
  freed by the caller 
*/
GSList *account_get_prefs_account_list(void);


/**
  This function removes the uidl table file associated with the account 
  @param  ac_prefs     pointer to account structure. 
  @return none 
*/
void account_remove_uidl_file(PrefsAccount * ac_prefs);

/**
  This function renames the uidl table file associated with the account 
  @param  old_name     pointer to old name. 
  @param  new_name     pointer to new name. 
  @return none 
*/
void account_rename_uidl_file(const gchar * old_name, const gchar * new_name);

/**
  This function copies PrefsAcount structure into another one
  
  @param prefs_account - Account information to be copied
  @return PrefsAccount - New structure containing the account info
*/
PrefsAccount *account_copy_prefs(PrefsAccount * s_update_prefsAccount);

/**
 This function copies PrefsAcount structure into another one
 
 @return in case of account list not NULL return TRUE otherwise returns FALSE
*/
gboolean is_account_list_valid(void);

#endif				/* __ACCOUNT_H__ */
