
/**
 * This file is part of osso-email-common
 *
 * Copyright (c) 2006 Nokia Corporation.
 * 
 * Contact: Dirk-Jan Binnema <dirk-jan.binnema@nokia.com>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */


#ifndef IAP_CONFSERV_H
#define IAP_CONFSERV_H

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#if CL_USE
#include <glib.h>


#define DBUS_API_SUBJECT_TO_CHANGE
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include "cl.h"

#define 	IAP_CONFSERV_RC		"iapconfserv.rc"

/**
   This method is used to get the locally stored iap list 
   @param none 
   @return list of iap configured servers 
*/
GSList *get_iap_confserv_list(void);

/**
   This method is used to sync up the iap list with locally maintained data 
   @param iaplist list of iapinfo  
   @return nothing 
*/
void iap_confsmtp_sync_serv_info_list(GSList *iaplist);

/**
   This method is used to update locally maintained list with latest data 
   @param iaplist list of iapinfo  
   @return nothing 
*/
gboolean iap_confsmtp_get_serv_info_list( GSList **iaplist);

/**
   This method is used to get the path of iap configured smtp data 
   @param none
   @return path of xml file 
*/
gchar *iap_smtpconfserv_rcpath(void);

/**
   This method is used to save the iap configured smtp data in xml file 
   @param none
   @return TRUE on success 
*/
gboolean iap_smtpconf_savelist(void);

/**
   This method is used to read the iap configured smtp data from xml file 
   @param none
   @return OSSO_PACK_OK on success and OSSO_PACK_ERROR on fail 
*/
gint iap_smtpconf_readlist(void);

/**
   This method is used to get iap info based on iapname 
   @param iapname iap name 
   @return iapinfo contains smtp server data 
*/
const IapInfo *iap_smtpconf_get_iap_info( const gchar *iapname);

/**
   This method is used to set iap info 
   @param iapinfo contains smtp server data 
   @return TRUE on successful updatation 
*/
gboolean iap_smtpconf_set_iap_info( const IapInfo *iapinfo);

#endif /* end of CL_USE */
#endif /* end of IAP_CONFSERV_H */

