
/**
 * This file is part of osso-email-common
 *
 * Copyright (c) 2006 Nokia Corporation.
 * 
 * Contact: Dirk-Jan Binnema <dirk-jan.binnema@nokia.com>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */


#ifndef CL_H
#define CL_H

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#if CL_USE

#define DBUS_API_SUBJECT_TO_CHANGE

#include<stdio.h>
#include<glib.h>
#include <log-functions.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <conic.h>


#include "utils.h"
#include "libosso.h"
#include "prefs_account.h"

#define CL_OK 0
#define CL_DEFAULT 10000
#define CL_INVALID_IAP ( CL_DEFAULT + 1 )
#define CL_ERROR_GET_LIST ( CL_DEFAULT + 2 )
#define CL_INIT_FAILURE ( CL_DEFAULT + 3 )
#define CL_INVALID_IAP_NAME ( CL_DEFAULT + 4 )
#define CL_ERROR_IAP_CONNECT ( CL_DEFAULT + 5 )
#define CL_ERROR_IAP_DISCONNECT ( CL_DEFAULT + 6 )
#define CL_ERROR_IAP_NOT_CONFIGURED ( CL_DEFAULT + 7 )
#define CL_INVALID_PARAM ( CL_DEFAULT + 8 )
#define CL_CONNECTION_CANCEL_REQUEST ( CL_DEFAULT + 9)

typedef struct _iapInfo IapInfo;
typedef struct _email_cl_wa email_cl_wa;

typedef enum {
	CL_IAP_WLAN = 1,
	CL_IAP_GPRS,
	CL_IAP_GSM
} IapType;

struct _email_cl_wa {
	gint status;
	GMainLoop *loop;
	ConIcConnection *connection;
	DBusConnection *dbusconn;
	GMainContext *gmainctx;
	gchar *cur_iap;
	gint conn_type;
	gboolean send_recv_cancel_skip;
	void (*cancel_mails_cb) (void);
};

struct _iapInfo {
	gchar 	*iap_name;
	gchar   *bearer;
	gchar 	*smtp_servname;
	gchar 	*smtp_username;
	gchar 	*smtp_passwd;
	gushort smtp_port;
	SMTPAuthType smtp_auth_type;
	gboolean smtp_use_ssl;
	gboolean smtp_use_tls;
	IapType iap_type;
	gint 	iap_status;
};

/**
    This is initialization function for connectivity layer 
    for email Application
    @param void *cb_func function for call back operations
    @return CL_OK on success or CL_INIT_FAILURE on fail 
*/
gint cl_init(void *cb_func);

/**
    This function is called to uninitialise connectivity context
    @param none
    @return none 
*/
void cl_uninit(void);

/**
   This function is called to connect specific iap 
   @param iap_name iap name
   @param con_type specfies the nature of connection to be opened.
   @return CL_OK on success or returns the cl layer error code 
*/
gint cl_iap_connect(const gchar * iap_name, gboolean con_type);

/**
   This function is called disconnect the specific iap
   @param iap_name iap name
   @return success or error code
*/
gint cl_iap_disconnect(const gchar * iap_name);

/**
   This function return iap_list as an out parameter
   @param iap_list
   @return return status
*/
gint cl_get_iap_info_list(GSList ** iap_list);

/**
   This function is used to free the memory
   @param iap_info iap information
   @return CL_OK on success or return error code 
*/
void cl_iap_info_free(IapInfo * iap_info);

/**
   This function is used to free the memory
   @param iap_info iap information
   @return CL_OK on success or return error code 
*/
gint cl_iap_info_list_free(GSList * iap_info_list);

/**
  This function is called to set the connection type. 
  @param type for timed out connection set to TRUE 
  @return nothing 
*/
void cl_iap_set_type(gboolean type);

/**
  This function is called to get the connection type. 
  @param none 
  @return nothing 
*/
gint cl_iap_get_type(void);

/**
  This function is used to get the status of current iap 
  @param option  TRUE means set status and FALSE means get the status
  @param val  to be set  
  @return nothing 
*/

gboolean cl_current_iap_status(gboolean option, gint val);

/**
  This function is used to disconnect the iap if any iap is currently
  connected.
  @param none
  @return none
*/

void cl_discon_cur_iap(void);

/**
  This function is used to disconnect at the time of connecting 
  @param void 
  @return nothing 
*/

void cl_cancel_iap_conn(void);

/**
  This function is returns the current activ iap 
  @param void 
  @return the current iap name 
*/
const gchar *cl_active_iap(void);
gboolean active_con_is_wlan(void);

#endif				//CL_USE
#endif				// CL_H
