
/**
 * This file is part of osso-email-common
 *
 * Copyright (c) 2006 Nokia Corporation.
 * 
 * Contact: Dirk-Jan Binnema <dirk-jan.binnema@nokia.com>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef DBUS_UTILS_XML_H_
#define DBUS_UTILS_XML_H_

#include <stdio.h>
#include <libxml/parser.h>
#include "dbus_utils_def.h"
#include <libosso.h>
#include <log-functions.h>
#include "procmime.h"

typedef enum {
	OSSO_PACK_OK = 0,	/* packing or unpacking success */
	OSSO_PACK_ERROR = -1,	/* packing or unpaking  failed */
	OSSO_PACK_INVALID = -2,	/* Received Null parameters */
	OSSO_PACK_ALLOC_FAIL = -3,	/*Memory alloc fail */
} osso_pack_return_t;

typedef osso_pack_return_t(*funcPtr) (xmlNodePtr node, xmlDocPtr doc, void *name, void *data);
typedef struct _DBusData DBusData;

typedef enum {
	D_INT = 1,
	D_BOOL,
	D_LONG,
	D_STRING,
	D_ENUM,
	D_STRUCT,
	D_GSLIST,
	D_STRING_LIST,
	D_MSG_INFO,
	D_MSG_INFO_LIST,
	D_MSG_HEADER,
	D_MSG_HEADER_LIST,
	D_EMAIL_SETTINGS,
	D_ATTACH_INFO,
	D_ATTACH_INFO_LIST,
	D_FOLDER,
	D_FOLDER_LIST,
	D_PRES_ACCOUNT_LIST,
	D_MIME_INFO,
	D_PARENT,
	D_CHILD,
	D_SUB,
	D_MIME_INLINE_INFO_LIST,
	D_MIME_INFO_LIST,
	D_FOLDER_ATTACH_INFO,
	D_PREFS_ACCNT,
	D_BOOLARR,
	D_INT_LIST,
	D_USHORT
} ElementType;

/* Tags for data to be packed */

#define    XML_DATA                     "Data"
#define    XML_MIME_INFO                "MimeInfo"
#define    XML_CHILD                    "Child"
#define    XML_SUB                      "Sub"
#define    XML_MIME_INFO_LST            "MimeInfo_list"
#define    XML_MSG_INFO                 "MsgInfo"
#define    XML_MSG_INFO_LST             "MsgInfo_list"
#define    XML_MSG_HEADER               "MsgHeader"
#define    XML_MSG_HEADER_LST           "MsgHeader_list"
#define    XML_INLINEIMAGE_INFO         "InlineImageInfo"
#define    XML_INLINEIMAGE_INFO_LST     "InlineImageInfo_list"
#define    XML_CERTS_UID_LST            "recip_certs_uid_list"
#define    XML_ALGOS_LST                "recip_algos_list"
#define    XML_MSG_TAG                  "MsgTag"
#define    XML_MSG_FLAGS                "MsgFlags"
#define    XML_SETTINGS                 "Settings"
#define    XML_ATTACHINFO               "AttachInfo"
#define    XML_ATTACHINFO_LST           "AttachInfo_list"
#define    XML_FOLDER                   "Folder"
#define    XML_FOLDER_LST               "Folder_list"
#define    XML_FOLDER_ATTACHINFO        "Folder_attachinfo"
#define    XML_FOLDER_ATTACHINFO_LST    "Folder_attachinfo_list"
#define    XML_PREFS_ACCOUNT            "PrefsAccount"
#define    XML_USER_SETTINGS            "UserSettings"
#define    XML_SEND_SETTINGS            "SendSettings"
#define    XML_RECV_SETTINGS            "ReceiveSettings"
#define    XML_ADV_SETTINGS             "AdvancedSettings"
#define    XML_SCHED_SETTINGS           "ScheduleSettings"
#define    XML_SCHED_DAY                "day"
#define    XML_PREFS_ACCOUNT_LST        "PrefsAccount_list"
#define    XML_MSG_ID_LST               "MsgId_list"
#define    XML_MSG_ID                   "MsgId"
#define    XML_INT                      "Int"
#define    XML_BOOL                     "Bool"
#define    XML_LONG                     "Long"
#define    XML_STRING                   "String"
#define    XML_STRING_LST               "String_list"
#define    XML_MESSAGE                  "Message"
#define    XML_FILE_NAME                "FileName"
#define    XML_CHARSET                  "Charset"
#define    XML_IAPINFO                  "IapInfo"
#define    XML_IAPINFO_LST              "IapInfo_list"
#define    XML_RETR_LST                 "Retr_list"
#define    XML_RETR_MSG                 "Retr_message"

#define    XML_EMAIL_STATE_INFO         "EmailStateInfo"
#define    XML_EMAIL_PERSISTENT_INFO    "EmailPersistentInfo"
#define    XML_FOLDER_SORT_INFO         "Folder_sort_info"
#define    XML_OPEN_WINDOW_DATA         "Open_window_data"
#define    XML_FOLDER_SORT_INFO         "Folder_sort_info"
#define    XML_MARKED_MSGS_LST          "Marked_msg_list"
#define    XML_FOLDER_SORT_INFO_LST     "Folder_sort_info_list"
#define    XML_OPEN_MSGS_LST            "OpenMsg_list"
#define    XML_ATTACH_TAG_LST           "attach_tag_list"
#define    XML_INT_LST                  "IntList"

/*Bug 15172*/
#define    XML_MSGID                    "old_msgid"

#define BOOL_ARR_SIZE        7
#define BUF_SIZE            20
#define  NEW_NODE(node, root, child, nodeType)          \
{                                                       \
    if ( node == NULL ) {                               \
        root = xmlNewNode ( NULL, BAD_CAST nodeType );  \
        xmlAddChild ( node, root );                     \
        node = root;                                    \
    } else {                                            \
        child = xmlNewNode ( NULL, BAD_CAST nodeType ); \
        xmlAddChild ( node, child );                    \
        node = child;                                   \
    }                                                   \
}

#define  DBUS_XML_PACK_INIT                          \
{                                                    \
    doc  = xmlNewDoc ( BAD_CAST "1.0" );             \
    root = xmlNewNode ( NULL, BAD_CAST (XML_DATA) ); \
    xmlDocSetRootElement ( doc, root );              \
}

#define  DBUS_XML_PACK_GET_DATA(pack_str)            \
{                                                    \
   xmlDocDumpFormatMemory ( doc, &xmlbuff, &buffersize, 1 ); \
   pack_str = g_strdup(xmlbuff->content);                    \
   xmlBufferFree(xmlbuff);                          \
   xmlbuff = NULL;                                  \
}

#define  DBUS_XML_PACK_UN_INIT                      \
{                                                   \
   xmlFreeDoc ( doc );                              \
   doc = NULL;                                      \
}

#define  DBUS_XML_UNPACK_INIT(msg, iffail)              \
{                                                       \
   if( msg == NULL) {                                   \
      iffail;                                           \
   }                                                    \
   doc = xmlParseMemory (msg , strlen ( msg ) );        \
   if ( doc == NULL ) {                                 \
      iffail;                                           \
   }                                                    \
   cur = xmlDocGetRootElement ( doc );                  \
   if ( (cur == NULL) || ( strcmp(cur->name, XML_DATA ) != 0) ) { \
      g_print ( "Doc contain wrong <Data> missed \n");  \
      xmlFreeDoc ( doc );                                         \
      iffail;                                                     \
   }                                                              \
}

#define  DBUS_XML_UNPACK_UN_INIT                     \
{                                                    \
   xmlFreeDoc ( doc );                               \
   doc = NULL;                                       \
}


struct _DBusData {
	gchar *name;
	ElementType type;
	gpointer data;
	funcPtr packFunc;
};



/* DBus Pack functions */

osso_pack_return_t osso_email_xml_pack_str(xmlNodePtr node, xmlDocPtr doc, void *name, void *data);

osso_pack_return_t
osso_email_xml_pack_str_base64(xmlNodePtr node, xmlDocPtr doc, void *name, void *data);
osso_pack_return_t osso_email_xml_pack_int(xmlNodePtr node, xmlDocPtr doc, void *name, void *data);
osso_pack_return_t osso_email_xml_pack_long(xmlNodePtr node, xmlDocPtr doc, void *name, void *data);
osso_pack_return_t
osso_email_xml_pack_ushort(xmlNodePtr node, xmlDocPtr doc, void *name, void *data);
osso_pack_return_t osso_email_xml_pack_bool(xmlNodePtr node, xmlDocPtr doc, void *name, void *data);
osso_pack_return_t
osso_email_xml_pack_msginfo(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *msgInfo);
osso_pack_return_t
osso_email_xml_pack_msgheader(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *msgHeader);
osso_pack_return_t
osso_email_xml_pack_msgflags(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *flags);
osso_pack_return_t
osso_email_xml_pack_msgtag(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *tag);
osso_pack_return_t
osso_email_xml_pack_settings(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *settings);
osso_pack_return_t
osso_email_xml_pack_inlineimageinfo(xmlNodePtr node, xmlDocPtr doc,
				    void *nodeType, void *imageinfo);
osso_pack_return_t
osso_email_xml_pack_inlineimageinfo_list(xmlNodePtr node, xmlDocPtr doc,
					 void *nodeType, void *data);
/**
   This function is used to pack the 'GSList of int'
   received into a xml 'doc' with identifier 'name'.
 
   @param  node   Xml Node pointer to pack the data
   @param  doc    Xml Doc  pointer to pack the data
   @param  name   Tag Identifier of the GSList of Int 
                  data in the xml document
   @param  data   GSList of Int data to be packed in xml format
   @return OSSO_PACK_OK on success (or) OSSO_PACK_INVALID for invalid 
                  parameter (or) OSSO_PACK_ERROR for other kind of errors
*/

osso_pack_return_t
osso_email_xml_pack_int_list(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *data);

osso_pack_return_t
osso_email_xml_pack_attachinfo_list(xmlNodePtr node, xmlDocPtr doc,
				    void *nodeType, void *attach_list);
osso_pack_return_t
osso_email_xml_pack_attachinfo(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *attachinfo);
osso_pack_return_t
osso_email_xml_pack_folder(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *folder);
osso_pack_return_t
osso_email_xml_pack_folder_attachinfo(xmlNodePtr node, xmlDocPtr doc,
				      void *nodeType, void *folder_attach_info);
osso_pack_return_t
osso_email_xml_pack_folder_list(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *data);
osso_pack_return_t
osso_email_xml_pack_string_list(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *data);
osso_pack_return_t
osso_email_xml_pack_msgid_list(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *data);
osso_pack_return_t
osso_email_xml_pack_folder_attachinfo_list(xmlNodePtr node, xmlDocPtr doc,
					   void *nodeType, void *data);
osso_pack_return_t
osso_email_xml_pack_msginfo_list(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *data);
osso_pack_return_t
osso_email_xml_pack_mimeinfo_list(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *data);
osso_pack_return_t
osso_email_xml_pack_msgheader_list(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *data);
osso_pack_return_t
osso_email_xml_pack_mimeinfo(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *mimeInfo);
osso_pack_return_t
osso_email_xml_pack_prefsaccount(xmlNodePtr node, xmlDocPtr doc,
				 void *nodeType, void *prefsAccount);
osso_pack_return_t
osso_email_xml_pack_user_settings(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *settings);
osso_pack_return_t
osso_email_xml_pack_recv_settings(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *settings);
osso_pack_return_t
osso_email_xml_pack_adv_settings(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *settings);
osso_pack_return_t
osso_email_xml_pack_sched_settings(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *settings);
osso_pack_return_t
osso_email_xml_pack_send_settings(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *settings);
osso_pack_return_t
osso_email_xml_pack_bool_arr(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *data);
osso_pack_return_t
osso_email_xml_pack_prefsaccount_list(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *data);
osso_pack_return_t
osso_email_xml_pack_account_list(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *data);
osso_pack_return_t
osso_email_xml_pack_iapinfo_list(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *data);
osso_pack_return_t
osso_email_xml_pack_iapinfo(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *iapinfo);
osso_pack_return_t
osso_email_xml_pack_emailStateInfo(xmlNodePtr node,
				   xmlDocPtr doc, void *nodeType, void *emailStateInfo);

/* DBus Unpack functions */

osso_pack_return_t
osso_email_xml_unpack_str(xmlNodePtr node, xmlDocPtr doc, void *name, void *data);
osso_pack_return_t
osso_email_xml_unpack_str_base64(xmlNodePtr node, xmlDocPtr doc, void *name, void *data);
osso_pack_return_t
osso_email_xml_unpack_int(xmlNodePtr node, xmlDocPtr doc, void *name, void *data);
osso_pack_return_t
osso_email_xml_unpack_long(xmlNodePtr node, xmlDocPtr doc, void *name, void *data);
osso_pack_return_t
osso_email_xml_unpack_ushort(xmlNodePtr node, xmlDocPtr doc, void *name, void *data);
osso_pack_return_t
osso_email_xml_unpack_bool(xmlNodePtr node, xmlDocPtr doc, void *name, void *data);
osso_pack_return_t
osso_email_xml_unpack_string_list(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, GSList ** data);
osso_pack_return_t
osso_email_xml_unpack_msgid_list(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, GSList ** data);
osso_pack_return_t
osso_email_xml_unpack_mimeinfo(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, void *data);
osso_pack_return_t
osso_email_xml_unpack_msginfo(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, void *data);
osso_pack_return_t
osso_email_xml_unpack_msgheader(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, void *data);
osso_pack_return_t
osso_email_xml_unpack_folder(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, void *data);
osso_pack_return_t
osso_email_xml_unpack_folder_attachinfo(xmlNodePtr node, xmlDocPtr doc,
					gchar * nodeType, void *data);
osso_pack_return_t
osso_email_xml_unpack_flags(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, void *data);
osso_pack_return_t
osso_email_xml_unpack_tag(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, void *data);
osso_pack_return_t
osso_email_xml_unpack_settings(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, void *data);
osso_pack_return_t
osso_email_xml_unpack_attachinfo(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, void *data);
osso_pack_return_t
osso_email_xml_unpack_attachinfo_list(xmlNodePtr node, xmlDocPtr doc,
				      gchar * nodeType, GSList ** data);
osso_pack_return_t
osso_email_xml_unpack_inlineimageinfo(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, void *data);
osso_pack_return_t
osso_email_xml_unpack_inlineimageinfo_list(xmlNodePtr node,
					   xmlDocPtr doc, gchar * nodeType, GSList ** data);

/**
  This function is used to unpack the 'GSList of int data'
  stored in a xml 'doc' with identifier 'name'

   @param  node   Xml Node pointer of the packed data
   @param  doc    Xml Doc  pointer of the packed data
   @param  name   Tag Identifier of the GSList of int 
                  data in the xml document
   @param  data   GSList of  int data will be stored
                  in this pointer
   @return OSSO_PACK_OK on success (or) OSSO_PACK_INVALID for invalid 
           parameter (or) OSSO_PACK_ERROR for other kind of errors
*/
osso_pack_return_t
osso_email_xml_unpack_int_list(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, GSList ** data);
osso_pack_return_t
osso_email_xml_unpack_folder_list(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, GSList ** data);
osso_pack_return_t
osso_email_xml_unpack_folderattachinfo_list(xmlNodePtr node, xmlDocPtr doc,
					    gchar * nodeType, GSList ** data);
osso_pack_return_t
osso_email_xml_unpack_msginfo_list(xmlNodePtr node, xmlDocPtr doc,
				   gchar * nodeType, GSList ** data);
osso_pack_return_t
osso_email_xml_unpack_mimeinfo_list(xmlNodePtr node, xmlDocPtr doc,
				    gchar * nodeType, GSList ** data);
osso_pack_return_t
osso_email_xml_unpack_msgheader_list(xmlNodePtr node, xmlDocPtr doc,
				     gchar * nodeType, GSList ** data);
osso_pack_return_t
osso_email_xml_unpack_prefsaccount_list(xmlNodePtr node, xmlDocPtr doc,
					gchar * nodeType, GSList ** data);
osso_pack_return_t
osso_email_xml_unpack_adv_settings(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, void *data);
osso_pack_return_t
osso_email_xml_unpack_sched_settings(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, void *data);
osso_pack_return_t
osso_email_xml_unpack_send_settings(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, void *data);
osso_pack_return_t
osso_email_xml_unpack_receive_settings(xmlNodePtr node, xmlDocPtr doc,
				       gchar * nodeType, void *data);
osso_pack_return_t
osso_email_xml_unpack_user_settings(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, void *data);
osso_pack_return_t
osso_email_xml_unpack_account(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, void *data);
osso_pack_return_t
osso_email_xml_unpack_bool_arr(xmlNodePtr node, xmlDocPtr doc, void *name, void *data);
osso_pack_return_t
osso_email_xml_unpack_prefsaccount(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, void *data);
void osso_email_xml_mimeinfo_free_all(MimeInfo * mimeinfo);

osso_pack_return_t
osso_email_xml_unpack_emailStateInfo(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, void *data);
osso_pack_return_t
osso_email_xml_unpack_iapinfo_list(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, void **data);
osso_pack_return_t
osso_email_xml_unpack_iapinfo(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, void *data);

osso_pack_return_t
osso_email_xml_pack_emailPersistentInfo(xmlNodePtr node, xmlDocPtr doc, void *nodeType, void *data);
osso_pack_return_t
osso_email_xml_unpack_emailPersistentInfo(xmlNodePtr node,
					  xmlDocPtr doc, gchar * nodeType, void *data);
osso_pack_return_t
osso_email_xml_pack_retr_list(xmlNodePtr node, xmlDocPtr doc, void *nodeType, GSList * msgid_list);
osso_pack_return_t
osso_email_xml_unpack_retr_list(xmlNodePtr node, xmlDocPtr doc, gchar * nodeType, GSList ** data);
#endif
