
/**
 * This file is part of osso-email-common
 *
 * Copyright (c) 2006 Nokia Corporation.
 * 
 * Contact: Dirk-Jan Binnema <dirk-jan.binnema@nokia.com>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef DBUS_UTILS_DEFS_H_
#define DBUS_UTILS_DEFS_H_
#include "osso-log.h"

#define EMAIL_DBUS_SERVICE           "com.nokia.osso_email"
#define EMAIL_DBUS_PATH              "/com/nokia/osso_email"
#define EMAIL_DBUS_INTERFACE         "com.nokia.osso_email"
#define EMAIL_DBUS_METHOD            "ConnectRemoteMethod"

#define UI_IS_READY                  "UI_is_ready"
#define UI_DISCONNECT_IAP            "UI_disconnect_iap"
#define APP_KILLER_SIGNAL            "App_killer_signal"
#define REMOVE_NOTIFICATIONS         "remove_notifications"

/* Send Mail Functionality */

#define    SEND_MAIL                 "send_mail"
#define    CANCEL_SEND_MAIL          "cancel_send_mail"
#define    SEND_OUTBOX_MAIL          "send_outbox_mail"
#define    SEND_SAVE_DRAFT_MAIL      "send_save_draft_mail"
#define    SEND_SELECTED_MAILS       "send_selected_mails"

/* Bug ID: 15172 crash when saving large email attachments*/
#define    SEND_GET_MSG_ID_CALLBACK      "send_get_msg_id_callback"
#define    SEND_GET_MSG_ID               "send_get_msg_id"

/* Receive Mail Functionality */

#define    RECV_MAIL                 "recv_mail"
#define    RECV_MSG_BODY             "recv_msg_body"
#define    RECV_MSG_BODY_CB          "recv_msg_body_through_callback"
#define    RECV_MSG_ATTACHMENT       "recv_msg_attachment"
#define    RECV_ATTACHMENT_CALLBACK  "recv_attachment_cb"
#define    RECV_MULTIPLE_ATTACHMENTS "recv_multiple_attachments"
#define    RECV_MULTIPART_BODY       "recv_multipart_body"
#define    CANCEL_RECV_MAIL          "cancel_recv_mail"
#define    RECV_MULTIPART_ATTACHMENT "recv_multipart_attachment"
#define    SEND_RECV_MAIL            "sendrecv_mail"
#define    UPDATE_SEEN_FLAG          "update_seen_flag"

#define    RECV_MSG_BODY_CALLBACK        "recv_msg_body_callback"
#define    RECV_MULTIPART_BODY_CALLBACK  "recv_multipart_body_callback"
#define    RECV_MSG_ATTACHMENT_CALLBACK  "recv_msg_attachment_callback"
#define    RECV_MULTIPART_ATTACHMENT_CALLBACK  "recv_mlutipart_attachment_callback"
#define    REMOVE_ATTACHMENT_CALLBACK  "rem_attachment_callback"
#define    REMOVEALL_ATTACHMENT_CALLBACK  "rem_all_attach_callback"
#define    REM_MSG_ATTACHMENTS          "rem_msg_attachments"

/* Account Management Functionality */

#define    GET_ACCOUNT_LIST          "get_account_list"
#define    GET_ACCOUNT_SETTINGS      "get_account_settings"
#define    SET_ACCOUNT_SETTINGS      "set_account-settings"
#define    DELETE_ACCOUNT            "delete_account"
#define    RENAME_ACCOUNT            "rename_account"
#define    ACCOUNT_CHECK_STATUS      "acct_check_status"

#define    GET_ACCOUNT_LIST_CALLBACK      "get_account_list_callback"
#define    GET_ACCOUNT_SETTINGS_CALLBACK  "get_account_settings_callback"
#define    DELETE_ACCOUNT_CALLBACK        "delete_account_callback"
#define    RENAME_ACCOUNT_CALLBACK        "rename_account_callback"
#define    ACCOUNT_CHECK_STATUS_CALLBACK  "acct_check_status_callback"
#define    SET_ACCOUNT_CALLBACK           "set_account_callback"

#define    FOLDER_CREATE             "folder_create"
#define    FOLDER_DELETE             "folder_delete"
#define    FOLDER_RENAME             "folder_rename"
#define    FOLDER_MOVE_MSG           "folder_move_msg"
#define    FOLDER_MOVE_MSGS          "folder_move_msgs"
#define    FOLDER_COPY_MSG           "folder_copy_msg"
#define    FOLDER_COPY_MSGS          "folder_copy_msgs"
#define    FOLDER_REMOVE_MSG         "folder_remove_msg"
#define    FOLDER_REMOVE_MSGS        "folder_remove_msgs"
#define    FOLDER_REMOVE_ALL_MSGS    "folder_remove_all_msg"
#define    FOLDER_GET_LIST           "folder_get_list"
#define    FOLDER_GET_SIZE           "folder_get_size"
#define    FOLDER_REMOVE_ATTACHMENT  "folder_remove_attachment"
#define    FOLDER_REMOVEALL_ATTACHMENT  "folder_removeall_attach"
#define    POPULATE_FOLDER           "populate_folder"
#define    FOLDER_CANCEL             "folder_cancel"

#define    FOLDER_GET_LIST_CALLBACK  "folder_get_list_callback"
#define    POPULATE_FOLDER_CALLBACK  "populate_folder_callback"
#define    FOLDER_OPERATION_CALLBACK "folder_operation_callback"
#define    PREFS_ACCOUNT_GET_LIST    "prefsaccount_get_list"
#define    PREFS_ACCOUNT_GET_LIST_CALLBACK "prefsaccount_get_list_callback"

/* Statesave Functionality */
#define    STATESAVE_READ           "statesave_read"
#define    STATESAVE_WRITE          "statesave_write"
#define    STATESAVE_READ_CALLBACK  "statesave_read_callback"
#define    STATESAVE_WRITE_CALLBACK  "statesave_write_callback"
#define    STATESAVE_SIGNAL         "statesave_signal"

/* TaskNav Finctionality */

#define    TASKNAV_WINDOW_OPERATION  "tasknav_window_operation"
#define    TASKNAV_WINDOW_ID         "tasknav_window_id"
#define    EDITOR_CREATE             "editor_create"
#define    TASKNAV_MSG_OPERATION     "tasknav_msg_opetation"
#define    TASKNAV_WINDOW_OPERATION_CALLBACK "tasknav_window_operation_callback"
#define    TASKNAV_OPEN_CONTACT      "tasknav_open_contact"
#define    TASKNAV_OPEN_INBOX        "tasknav_open_inbox"
#define    BROWSER_LOAD_FINISHED     "browser_load_finished"
#define    EMBED_BROWSER_KEY_EVENT   "browser_key_event"

#define    GET_ENGINE_ERRNO          "get_engine_errno"
#define    GET_ENGINE_INIT_STATUS    "get_engine_init_status"
#define    HTML_TO_TEXT_CONVERTER    "html_to_text_converter"
#define    ACCT_ERROR_CODE           "acct_error_code"
#define    GET_MSG_HEADER_LIST       "get_msg_header_list"

#define   SMTP_PARAM_VALUE_MISSING    "smtp_param_value_missing"
#define   SMTP_SET_MSG                "smtp_set_msg"
#define   SMTP_SET_PERCENTAGE         "smtp_set_percentage"
#define   SMTP_UPDATE_FOLDER_VIEW     "smtp_update_folder_view"
#define   SMTP_UPDATE_OUTBOX_MAILS_SENT "smtp_update_outbox_mails_count"
#define   SMTP_SEND_COMPLETE          "smtp_send_complete"

#define   POP3_PARAM_VALUE_MISSING    "pop3_param_value_missing"
#define   POP3_SET_MSG                "pop3_set_msg"
#define   POP3_SET_PERCENTAGE         "pop3_set_percentage"
#define   POP3_RECV_SINGLE            "pop3_recv_single"
#define   POP3_RECV_COMPLETE          "pop3_recv_complete"
#define   POP3_RECV_BODY_COMPLETE     "pop3_recv_body_complete"

#define   IMAP4_PARAM_VALUE_MISSING   "imap4_param_value_missing"
#define   IMAP4_SET_MSG               "imap4_set_msg"
#define   IMAP4_MSG_HEADERS           "imap4_msg_headers"
#define   MMC_HLR                     "mmc_hlr"

#define GET_ENGINE_ERRNO_CALLBACK         "get_engine_errno_callback"
#define GET_ENGINE_INIT_STATUS_CALLBACK   "get_engine_init_status_callback"
#define HTML_TO_TEXT_CONVERTER_CALLBACK   "html_to_text_converter_callback"
#define GET_MSG_HEADER_LIST_CALLBACK      "get_msg_header_list_callback"

#define GET_IAPINFO_LIST          "get_iapinfo_list"
#define GET_IAPINFO_LIST_CALLBACK "get_iapinfo_list_callback"
#define SET_IAPINFO_SETTINGS       "set_iapinfo_settings"
#define SET_IAPINFO_SETTINGS_CALLBACK  "set_iapinfo_settings_callback"
#define GET_IAPINFO_SETTINGS       "get_iapinfo_settings"
#define GET_IAPINFO_SETTINGS_CALLBACK "get_iapinfo_settings_callback"

#define AUTOSAVE_MAIL                 "autosave_mail"
#define AUTOSAVE_MAIL_CALLBACK        "autosave_mail_callback"

#define EDITOR_OPEN_MAIL              "editor_open_mail"
#define SET_TMP_PASSWD                "set_tmp_passwd"
#define ENGINE_CHECK_STATUS      "engine_check_status"
#define ENGINE_STATUS_CALLBACK	"engine_check_status_callback"
#define ATTACH_LIST_CB      "attach_list_callback"

#define CB_FLAG "cb_flag"
#define READ_FLAG "read_flag"
#define ATTA_TAG "attachment_tag"
#define EDIT_FLAG "edit_flag"
#define HTML_FLAG "html_flag"
#define SEND_FLAG "send_flag"
#define CERT_ID "cert_id"
#define PASS "pass"

#define PASSWORD_KEY "password_key"

#define DBUS_TIME_WAIT 60000
#define MEM_ALLOC_SIZE1 128



#define     STATUS                 "Status"
#define     IPADDR                 "IPAddr"
#define     OUTBOXMAILSCOUNT       "OutBoxMailsCount"
#define     OUTBOXMAILSSENT        "OutBoxMailsSent"
#define     RECVCOUNT              "RecvCount"
#define     TOTALCOUNT             "TotalCount"
#define     ACCOUNT                "Account"
#define     ACCOUNT_NAME           "ACCOUNT_NAME"
#define     OLD_ACCOUNT_NAME       "OLD_ACCOUNT_NAME"
#define     NEW_ACCOUNT_NAME       "NEW_ACCOUNT_NAME"
#define     FOLDER_NAME            "FOLDER_NAME"
#define     PATH                   "PATH"
#define     TYPE                   "TYPE"
#define     FOLDER_OLD_NAME        "FOLDER_OLD_NAME"
#define     FOLDER_NEW_NAME        "FOLDER_NEW_NAME"
#define     SRC_FOLDER        "SRC_FOLDER"
#define     DES_FOLDER        "DES_FOLDER"
#define     MSGID             "MSGID"
#define     FLAG              "FLAG"
#define     INDEX             "INDEX"
#define     FOLDER_STATUS     "STATUS"

#define   AL_FOLDER_LST           "al_folder_headers"
#define   AL_FOLDER_MSG           "al_folder_msg"
#define   RX_DEL_LST            "rx_del_headers"
#define   AL_RETR_MSGS          "retreive_msgs"
#define   AL_RETR_MSGS_STATUS   "retreive_msgs_status"

/* SMIME changes*/
#define SENDER_ID       "SENDER_EMAIL"
#define RECIP_ID        "RECIP_EMAIL"
#define SMIME_TYPE      "SMIME"


#define seperator  ":"

#define TRNSLDIGIT(c) ((c) <= '9' ? (c) - '0' : ((c) & 0x4F) - 'A' + 10)


#define   MGR_CHECK_STATUS( condition, message, iffail)               \
{                                                                     \
   if(condition) {                                                    \
      osso_log(LOG_INFO, " %s ", message);                            \
      iffail ;                                                        \
   }                                                                  \
}
#define BUFLEN  256
#define TLEN    11

#define  EMAIL_LOG( f, arg...)  \
{                               \
   gchar buf[BUFLEN + TLEN];    \
   time_t t;                    \
   time(&t);                    \
   strftime(buf, TLEN+1, "[%H:%M:%S] ", localtime(&t));     \
   g_snprintf(buf + TLEN, BUFLEN, "%s:%s "f"\n",__FILE__, __func__,  ##arg); \
   ULOG_INFO_F("%s", buf);      \
   g_print("%s", buf);          \
   LOG_CLOSE();                 \
}

#endif
