
/*
 * LibSylph -- E-Mail client library
 * Copyright (C) 1999-2006 Hiroyuki Yamamoto
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __DBUSUTILS_H__
#define __DBUSUTILS_H__

#include <glib.h>

#define RC_DIR_DBUS      		"email"
#define CONFIG_FILE_PATH_DBUS           "/apps/email/settings"
#define G_DIR_SEPARATOR_DBUS		"/"



typedef struct _Base64DecoderDBUS Base64DecoderDBUS;
typedef struct _InlineImageInfoDBUS InlineImageInfoDBUS;

struct _Base64DecoderDBUS {
	gint buf_len;
	gchar buf[4];
};

struct _InlineImageInfoDBUS {
	gchar *uri_path;
	gchar *content_id;
	gchar *image_name;
	gchar *image_path;
};

gchar *get_rc_dir_dbus(void);

void procmsg_ImageInfo_list_free_DBUS(GSList * image_list);
void procmsg_ImageInfo_free_DBUS(InlineImageInfoDBUS * info);

void base64_encode_dbus(gchar * out, const guchar * in, gint inlen);
gint base64_decode_dbus(guchar * out, const gchar * in, gint inlen);



#if 0
Base64DecoderDBUS *base64_decoder_new_dbus(void);

void base64_decoder_free_dbus(Base64Decoder * decoder);

gint base64_decoder_decodedbus(Base64Decoder * decoder, const gchar * in, guchar * out);
#endif

#endif				/* __DBUSUTILS_H__ */
