/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __GMOZILLAENGINE_H__
#define __GMOZILLAENGINE_H__

#include <gwebengine.h>
// gtk stuff
#include "gdk/gdkx.h"
#include "gtk/gtk.h"


G_BEGIN_DECLS

/** Input Method Context
  */
enum
{
  IM_SIG_HAS_SELECTION,
  IM_SIG_CLIPBOARD_OPERATION,
  IM_SIG_RETRIEVE_SURROUNDING,
  IM_SIG_DELETE_SURROUNDING,
  IM_SIG_COMMIT,
  IM_SIG_PREEDIT_CHANGED,
  IM_SIG_PREEDIT_START,
  IM_SIG_PREEDIT_END,
  IM_NUM_SIGNALS
};

//#define FEED_PROTOCOL "feed://"
//#define FEED_PROTOCOL_LENGTH 7

/** GMozillaEngine
  */

#define G_TYPE_MOZILLA_ENGINE             (g_mozilla_engine_get_type ())
#define G_MOZILLA_ENGINE(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_MOZILLA_ENGINE, GMozillaEngine))
#define G_MOZILLA_ENGINE_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), G_TYPE_MOZILLA_ENGINE, GMozillaEngineClass))
#define G_IS_MOZILLA_ENGINE(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_MOZILLA_ENGINE))
#define G_IS_MOZILLA_ENGINE_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), G_TYPE_MOZILLA_ENGINE))
#define G_MOZILLA_ENGINE_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), G_TYPE_MOZILLA_ENGINE, GMozillaEngineClass))

typedef struct _GMozillaEngine GMozillaEngine;
typedef struct _GMozillaEngineClass GMozillaEngineClass;

/** @struct GMozillaEngine.
  * Defines a Mozilla Engine.
  */
struct _GMozillaEngine
{
    GObject parent;
    GObject* engine;
    GObject* global;

    /* Context Info */
    gint doc_index, x, y;
    guint ctx_type;
    guint moz_ctx_type;
    gpointer ctx_node;
    gchar *ctx_url, *ctx_objurl, *ctx_docurl;
    //GtkIMContext *im_context;
	GtkIMContext *gtkIMContext;
    gulong im_signal_cb[IM_NUM_SIGNALS];
    GdkExtensionMode extended_im_mode;
    gint im_surr_offset;
    gint im_surr_num;
    gboolean im_surr_enable;
    guint32 mChromeMask;
    gboolean isFkbShowed;
    gpointer last_event;

    /* small workaround for some JS progress values sent after finish loading */
    gboolean is_loading;

    /* Authentication stuff */
    gchar * username;                         /** < The user's name (used by the password manager) */
    gchar * password;                         /** < The user's password (used by the password manager) */
    gboolean accept;                          /** < If it accepts or not store informations about authentication */
    gchar *last_location;
    
    gint last_net_status;
    guint sec_mode;
    GArray *signals_array;
    gint signals_array_len;
    
    gint current_zoom;
    gboolean optimized_view;
    gchar *will_open_location;
    gboolean waiting_connection;
    gboolean user_iteraction_happens;         /* Workaround against specification, and useless Connectivity Info */
    gint progress_bar_state;                  /* Helper variale to control and reduce messaging between UI and Our hacked progress bar ;) */
    guint page_size;
    guint scroll_to_node_timer_id;
    guint vkb_up_timeout;
    gboolean mouse_down;
};

/** @struct GMozillaEngineClass.
  * Defines the callbacks signals for the Mozilla Engine.
  */
struct _GMozillaEngineClass
{
    GObjectClass parent_class;
    void      (*url_changed)                (GMozillaEngine *, char *);
    void      (*title_changed)              (GMozillaEngine *, char *);
    void      (*close_window)               (GMozillaEngine *);
    void      (*start_loading)              (GMozillaEngine *, const char *);
    void      (*finished_loading)           (GMozillaEngine *, int, int, int);
    void      (*progress)                   (GMozillaEngine *, gint curprogress, gint maxprogress);
    void      (*window_request)             (GMozillaEngine *, gpointer, char *, gboolean);
    void      (*icon)                       (GMozillaEngine *, gpointer);
    void      (*loading_progress)           (GMozillaEngine *, gint, gint);
    gint      (*encoding)                   (GMozillaEngine *, guint encoding);
    void      (*security_mode_changed)      (GMozillaEngine *, gpointer, guint);
    gint      (*download_request)           (GMozillaEngine *, const gchar *, const gchar *, const gchar *, glong, gint);
    gint      (*authentification_required)  (GMozillaEngine *, gint, gchar *);
    gint      (*alert)                      (GMozillaEngine *, const gchar *);
    gboolean  (*confirm)                    (GMozillaEngine *, const gchar *);
    gchar*    (*prompt)                     (GMozillaEngine *, const gchar *, const gchar *);
    gboolean* (*select)                     (GMozillaEngine *, const gchar *, const gchar *, gpointer, gpointer);
    gint      (*mailto)                     (GMozillaEngine *, const gchar *);
    gint      (*rss_request)                (GMozillaEngine *, gchar *, gchar *);
    void      (*unknown_protocol)           (GMozillaEngine *, const gchar *);
    void      (*raise_request)              (GMozillaEngine *);
    gint      (*modal_dialog)               (GObject *, const gchar *, const gchar *, gint, gint, gint, gint);
    void      (*lower_request)              (GMozillaEngine *);
    gboolean  (*upload_dialog)              (GMozillaEngine *, const gchar *, const gchar *, gpointer);
    void      (*file_upload_started)        (GMozillaEngine *);
    void      (*file_upload_progress)       (GMozillaEngine *, gint, const gchar *);
    void      (*file_upload_finished)       (GMozillaEngine *);
    void      (*webengine_popup_menu)       (GMozillaEngine *, guint, gint, gint, gchar *, gchar *, gchar *, gchar *);
    void      (*external_action)            (GMozillaEngine *, const gchar *);
    void      (*frame_stacking_changed)     (GMozillaEngine *, gboolean);
    gint      (*modal_certificate_dialog)   (GMozillaEngine *, const gchar *, gint, gint, gint, gint, gint);
};

GType g_mozilla_engine_get_type (void);

/** Creates a new mozilla engine instance
  * @return A mozilla engine object
  */
GObject* g_mozilla_engine_new (void);

/** Creates a new mozilla engine instance with a context
  * @param context It is a pointer of the context data struct
  * @return A mozilla engine object according to the context data
  */
GObject* g_mozilla_engine_new_with_context (gpointer context);

/** Creates a new mozilla engine instance with context and tracks
  * @param context It is a pointer of the context data struct
  * @param leave_tracks If the mozilla engine is with or without tracks
  * @return A mozilla engine with context and tracks
  */
GObject* g_mozilla_engine_new_with_context_and_tracks (gpointer context,
        gboolean leave_tracks, gboolean without_history);

G_END_DECLS

#endif /* __GMOZILLAENGINE_H__ */
