/**
 * This file is part of maemo-examples package
 * 
 * Copyright (c) 2007 Nokia Corporation. All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE. */

/* Hildon includes */
#include <hildon/hildon-note.h>
#include <hildon/hildon-banner.h>
#include <hildon/hildon-sound.h>
#include <hildon/hildon-defines.h>
#include <libhildondesktop/libhildondesktop.h>

#include <log-functions.h>
#include <libosso.h>
#include <osso-log.h>

/* GTK includes */
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdkpixbuf.h>

/* Systems includes */
#include <string.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "hildon-sb-helloworld.h"

HD_DEFINE_PLUGIN(HildonStatusBarHelloWorld,
		 hildon_status_bar_helloworld,
	       	 STATUSBAR_TYPE_ITEM);

#define HILDON_STATUS_BAR_HELLOWORLD_GET_PRIVATE(x) \
	    (G_TYPE_INSTANCE_GET_PRIVATE((x), \
                                         hildon_status_bar_helloworld_get_type(), \
                                         HildonStatusBarHelloWorldPrivate));

static gboolean helloworld_icon_pressed(GtkWidget *widget, GdkEventButton *button,
                                        gpointer data);
static void hildon_status_bar_helloworld_finalize(GObject *object);

static void hildon_status_bar_helloworld_class_init(
		HildonStatusBarHelloWorldClass *klass)
{
    GObjectClass *object_class = G_OBJECT_CLASS(klass);
    object_class->finalize = hildon_status_bar_helloworld_finalize;
    g_type_class_add_private(klass, sizeof(HildonStatusBarHelloWorldPrivate));
}

static void set_helloworld_icon(const gchar *name, HildonStatusBarHelloWorldPrivate *info)
{
    GtkIconTheme *icon_theme;
    GdkPixbuf    *pixbuf;

    icon_theme = gtk_icon_theme_get_default();

    pixbuf = (name != NULL) ? gtk_icon_theme_load_icon(icon_theme, name,
                                                       HILDON_STATUS_BAR_HELLOWORLD_ICON_SIZE,
                                                       GTK_ICON_LOOKUP_NO_SVG, NULL) : NULL;

    gtk_image_set_from_pixbuf(GTK_IMAGE(info->icon), pixbuf);

    if (pixbuf != NULL)
        g_object_unref(pixbuf);
}

/**
 * Callback for the button clicked signal
 *
 * @param widget the button widget
 * @param data helloworld info struct
 */
static gboolean helloworld_icon_pressed(GtkWidget *widget, GdkEventButton *button,
                                        gpointer data)
{
    HildonStatusBarHelloWorldPrivate *info;

    g_return_val_if_fail(data, FALSE);
    info = (HildonStatusBarHelloWorldPrivate*)data;

    gtk_button_released(GTK_BUTTON(info->button));

    (void) button;

    hildon_banner_show_information(NULL, NULL, "foo");

    return TRUE;
}

static void hildon_status_bar_helloworld_finalize(GObject *object)
{
    HildonStatusBarHelloWorldPrivate *info = HILDON_STATUS_BAR_HELLOWORLD_GET_PRIVATE(object);

    osso_deinitialize(info->osso);

    LOG_CLOSE();

    G_OBJECT_CLASS(g_type_class_peek_parent(G_OBJECT_GET_CLASS(object)))->finalize(object);
}

static void hildon_status_bar_helloworld_init(HildonStatusBarHelloWorld *helloworld)
{
    HildonStatusBarHelloWorldPrivate *info = 
        HILDON_STATUS_BAR_HELLOWORLD_GET_PRIVATE(helloworld);

    ULOG_OPEN("hildon-sb-helloworld");

    g_return_if_fail(info);

    info->icon = gtk_image_new_from_pixbuf(NULL);
    info->button = gtk_toggle_button_new();

    set_helloworld_icon("hello", info);

    gtk_container_add(GTK_CONTAINER(info->button),
                      GTK_WIDGET(info->icon));

    gtk_container_add(GTK_CONTAINER(helloworld), info->button);

    /* Signal for icon (button) */
    g_signal_connect(G_OBJECT(info->button), "button-press-event",
                     G_CALLBACK(helloworld_icon_pressed), info);

    /* Initialize osso */
    info->osso = osso_initialize("hildon_sb_helloworld", "1.0", FALSE, NULL);
    if (!info->osso)
        ULOG_WARN("%s: error while initializing osso\n", __FUNCTION__);

    gtk_widget_show_all(GTK_WIDGET(helloworld));
}
