/**
 * This file is part of maemo-examples package
 * 
 * Copyright (c) 2007 Nokia Corporation. All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE. */

#include <gtk/gtk.h>
#include <libosso.h>
#include <hildon/hildon-program.h>
#include <hildon/hildon-help.h>
#include <hildon/hildon-color-chooser-dialog.h>

#define OSSO_EXAMPLE_NAME    "example_help_framework"

#define OSSO_HELP_TOPIC_EXAMPLE "osso_example_help"

/* Application UI data struct */
typedef struct {
    HildonProgram *program;
    HildonWindow *window;
    osso_context_t *osso_context;
} AppData;

AppData appdata;

/* Handlers */
void help_activated(GtkWidget *win, gchar *help_id)
{
    osso_return_t retval;

    if (!help_id) {
        return;
    }

    retval = hildon_help_show(appdata.osso_context, help_id, HILDON_HELP_SHOW_DIALOG);
}

void button_clicked(GtkWidget *widget, gpointer data) {
    GtkWidget *dialog;
    guint result;

    /* dialog = GTK_WIDGET(hildon_color_chooser_new()); */
    dialog = hildon_color_chooser_dialog_new();

    /* enable help system on dialog */
    hildon_help_dialog_help_enable(
        GTK_DIALOG(dialog),
        OSSO_HELP_TOPIC_EXAMPLE,
        appdata.osso_context
    );

    result = gtk_dialog_run(GTK_DIALOG(dialog));
    gtk_widget_destroy(dialog);
    return;
}

/* Main application */
int main(int argc, char *argv[])
{
    /* Create needed variables */
    GtkWidget *main_vbox;
    GtkWidget *button;
    GtkWidget *help_button;

    /* Initialize the GTK. */
    gtk_init(&argc, &argv);
    
    /* Initialize maemo application */
    appdata.osso_context = osso_initialize(OSSO_EXAMPLE_NAME, "0.0.1", TRUE, NULL);

    /* Check that initialization was ok */
    if (appdata.osso_context == NULL) {
        return OSSO_ERROR;
    }

    /* Create the hildon application and setup the title */
    appdata.program = HILDON_PROGRAM(hildon_program_get_instance());
    g_set_application_name("App Title");

    /* Create HildonWindow and set it to HildonProgram */
    appdata.window = HILDON_WINDOW(hildon_window_new());
    hildon_program_add_window(appdata.program, appdata.window);

    /* Add vbox to window */
    main_vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(appdata.window), main_vbox);

    /* Add button to vbox */
    button = gtk_button_new_with_label("Dialog");
    g_signal_connect(G_OBJECT(button), "clicked",
                     G_CALLBACK(button_clicked), NULL);
    gtk_box_pack_start(GTK_BOX(main_vbox), button, FALSE, TRUE, 0);
    
    /* Add help_button to vbox */
    help_button = gtk_button_new_with_label("Help");
    g_signal_connect(G_OBJECT(help_button), "clicked",
                     G_CALLBACK(help_activated), OSSO_HELP_TOPIC_EXAMPLE);
    gtk_box_pack_start(GTK_BOX(main_vbox), help_button, FALSE, TRUE, 0);

    /* Begin the main application */
    gtk_widget_show_all(GTK_WIDGET(appdata.window));

    /* Connect signal to X in the upper corner */
    g_signal_connect(G_OBJECT(appdata.window), "delete_event",
      G_CALLBACK(gtk_main_quit), NULL);

    gtk_main();

    /* Deinitialize OSSO */
    osso_deinitialize(appdata.osso_context);

    /* Exit */
    return 0;
}

/* vim:ts=4:sw=4:et:ai:si:showmatch
 */
