#include <gps.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>

#ifdef __i386__
#define SKIP_GPSBT
#else
#include <gpsbt.h>
#endif

#define ERROR_BUF_LEN 1024
#define GPSD_CONNECT_RETRIES 3

static void gps_callback(struct gps_data_t *sentence,
		char *buf, size_t len, int level)
{
	static int status = -1;
	g_message("Got GPS data\n");

	if(sentence->status != status)
	{
		status = sentence->status;
		if(status == 2)
			g_message("Got GPS Fix with DGPS\n");
		else if(status == 1)
			g_message("Got GPS Fix without DGPS\n");
		else
			g_message("No GPS Fix\n");
	}

	if(sentence->fix.mode >= 2)
	{
		g_message("Position: Lat: %f Long: %f +/-%fm\n",
				sentence->fix.latitude,
				sentence->fix.longitude,
				sentence->fix.eph);
		g_message("Speed %fm/s +/-%fm/s\n",
				sentence->fix.speed,
				sentence->fix.eps);
	}
	
}

int main(int argc, char **argv)
{
	int status;
	int i;
	gchar error[ERROR_BUF_LEN];
	struct gps_data_t *gpsdata;
	pthread_t gps_thread;
	GMainLoop *mainloop;
	
#ifndef SKIP_GPSBT
	gpsbt_t ctx = {0};
	status = gpsbt_start(NULL,
			1, 1,
			0,
			error, ERROR_BUF_LEN,
			0, &ctx);
#endif
	
	if(!status)
	{
		g_warning("Could not start GPS: %s\n", error);
		return 1;
	}

	for(i = 0; i < GPSD_CONNECT_RETRIES; ++i)
	{
		g_message("Opening connection to GPSD, try %d/%d\n", i+1,
				GPSD_CONNECT_RETRIES);
		gpsdata = gps_open(NULL, 0);
		if(gpsdata)
			break;
		sleep(1);
		g_message("Couldn't connect to GPSD: %s\n", g_strerror(errno));
	}

	if(!gpsdata)
	{
		g_warning("Connecting to GPS failed, terminating\n");
		return 1;
	}

	status = gps_set_callback(gpsdata, gps_callback, &gps_thread);

	if(status)
	{
		g_warning("Couldn't create GPS thread\n");
		return 1;
	}

	g_message("Connected to GPSD, waiting for data\n");
	
	mainloop = g_main_new(FALSE);
	g_main_run(mainloop);

	gps_del_callback(gpsdata, &gps_thread);
	gps_close(gpsdata);
#ifndef SKIP_GPSBT
	gpsbt_stop(&ctx);
#endif
	
	return 0;

}
