/**
 * This file is part of maemo-examples package
 * 
 * Copyright (c) 2007 Nokia Corporation. All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE. */

#include <hildon/hildon-program.h>
#include <hildon/hildon-file-details-dialog.h>

#include <gtk/gtk.h>
#include <stdlib.h>
#include <limits.h>
#include <errno.h>
#include <string.h>

/* Application UI data struct */
typedef struct _AppData AppData;
struct _AppData {
    HildonProgram *program;
    HildonWindow *window;
};

/* This variable will get filled with the
 * filename that was called to run this program
 * and it will be inspected by the file details dialog*/
static char *global_running_file;

#define TEXT_FILE "/MyDocs/.example/foo.txt"

static HildonFileSystemModel* get_file_system_model(GtkWidget *ref_widget)
{
	 return HILDON_FILE_SYSTEM_MODEL(g_object_new(HILDON_TYPE_FILE_SYSTEM_MODEL,
				         "ref_widget", ref_widget, NULL));
}



void callback_file_details(GtkWidget * widget, AppData * data)
{
    HildonFileDetailsDialog *dialog;
    GtkWidget *label = NULL;
    HildonFileSystemModel *model = NULL;
    gint result;
    GtkTreeIter iter;

    /* Create dialog */
    /* DEPRECATED
    dialog = HILDON_FILE_DETAILS_DIALOG
        (hildon_file_details_dialog_new(GTK_WINDOW(data->window), global_running_file)); */

    if( (model = get_file_system_model(GTK_WIDGET(data->window)) ) == NULL)
    {
       g_print("could not get file system model\n\n");
       return;
    }
    if( !hildon_file_system_model_load_uri( model,
                                            global_running_file,
                                            &iter ) )
    {
        g_print("could not load uri %s\n", global_running_file);
        return;
    }
    
    dialog = HILDON_FILE_DETAILS_DIALOG
              (hildon_file_details_dialog_new_with_model(GTK_WINDOW(data->window), model));

    hildon_file_details_dialog_set_file_iter
       (HILDON_FILE_DETAILS_DIALOG(dialog), &iter);

    /* Set the dialog to show tabs */
    g_object_set(dialog, "show-tabs", TRUE, NULL);

    /* Create some content to additional tab */
    label =
        gtk_label_new(g_strdup_printf
                      ("Name of this \nfile really is:\n%s", global_running_file)
        );

    /* Add content to additional tab label */
    g_object_set(dialog, "additional-tab", label, NULL);

    /* Change tab label */
    g_object_set(dialog, "additional-tab-label", "More Info", NULL);

    /* Show the dialog */
    gtk_widget_show_all(GTK_WIDGET(dialog));

    /* Wait for user to select OK or CANCEL */
    result = gtk_dialog_run(GTK_DIALOG(dialog));

    /* Close the dialog */
    gtk_widget_destroy(GTK_WIDGET(dialog));

}

int main(int argc, char *argv[])
{
    /* Create needed variables */
    HildonProgram *program;
    HildonWindow *window;
    GtkWidget *button;
    GtkWidget *vbox;
    AppData *appdata;
    char text_file[256] = "";

    /* Initialize the GTK. */
    gtk_init(&argc, &argv);

    
    sprintf(text_file,"%s/%s", getenv("HOME"), TEXT_FILE);
    /** File details dialog needs an absolute path */
    if(!(global_running_file = realpath(text_file, NULL)))
    {
	    g_error("Couldn't get absolute path (for %s): %s", text_file, strerror(errno));
	    return 1;
    }
    
    /* Create the hildon program and setup the title */
    program = HILDON_PROGRAM(hildon_program_get_instance());
    g_set_application_name("Hello maemo!");

    /* Create HildonWindow and set it to HildonProgram */
    window = HILDON_WINDOW(hildon_window_new());
    hildon_program_add_window(program, window);

    /* Create AppData */
    appdata = g_new0(AppData, 1);
    appdata->program = program;
    appdata->window = window;

    /* Create buttons and add it to main view */
    vbox = gtk_vbox_new(TRUE, 5);

    /* Test */
    button = gtk_button_new_with_label("File Details");
    g_signal_connect(G_OBJECT(button), "clicked",
                     G_CALLBACK(callback_file_details), appdata);
    gtk_container_add(GTK_CONTAINER(vbox), button);

    /* Add VBox to AppView */
    gtk_container_add(GTK_CONTAINER(window), vbox);

    /* Connect signal to X in the upper corner */
    g_signal_connect(G_OBJECT(window), "delete_event",
      G_CALLBACK(gtk_main_quit), NULL);

    /* Begin the main application */
    gtk_widget_show_all(GTK_WIDGET(window));
    gtk_main();

    /* Exit */
    return 0;
}
