/**
 * This file is part of maemo-examples package
 * 
 * Copyright (c) 2007 Nokia Corporation. All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE. */

#include <hildon/hildon-program.h>
#include <hildon/hildon-file-chooser-dialog.h>

#include <gtk/gtk.h>

/* Application UI data struct */
typedef struct _AppData AppData;
struct _AppData {
	HildonProgram *program;
	HildonWindow *window;
	
	GtkWidget * main_vbox;
	GtkWidget * label;

	/* Menu stuff */
	GtkMenu * main_menu;
	GtkWidget * menu_item_file_open;
	GtkWidget * menu_item_file_save;
	GtkWidget * menu_item_quit;
};

void example_show_test_result (AppData * data, gchar * test_name, gchar * test_result)
{
	gchar * label_text = g_strdup_printf ("File Chooser Example.\n\n%s:\n\n%s.", test_name, test_result);
	gtk_label_set_text (GTK_LABEL (data->label), label_text);
	g_free(label_text);
}

gchar * interface_file_chooser (AppData * appdata, GtkFileChooserAction action)
{
	GtkWidget *dialog;
	gchar *filename = NULL;
	
	dialog = hildon_file_chooser_dialog_new (GTK_WINDOW (appdata->window), action);
	gtk_widget_show_all (GTK_WIDGET (dialog));

	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK) {
		filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
	}

	gtk_widget_destroy(dialog);
	return filename;
}

void cb_example_file_open (GtkWidget * w, AppData * data)
{
	gchar *filename = NULL;
	    
	filename = interface_file_chooser (data, GTK_FILE_CHOOSER_ACTION_OPEN);

	if (filename == NULL) {
		filename = "NULL";
	}

	example_show_test_result (data, "Open File", filename);
}

void cb_example_file_save (GtkWidget * w, AppData * data)
{
	gchar *filename = NULL;
	filename = interface_file_chooser (data, GTK_FILE_CHOOSER_ACTION_SAVE);

	if (filename == NULL) {
		filename = "NULL";
	}
	else {
		FILE * f = fopen (filename, "w");
		fprintf (f, "This file was generated by Hildon File Chooser example.");
		fclose (f);
	}

	example_show_test_result (data, "File saved as", filename);

	
}

void cb_example_quit (GtkWidget *w, AppData * data)
{
	gtk_main_quit ();
}

void example_create_menu (AppData * data)
{
	data->main_menu = GTK_MENU(gtk_menu_new());

	/* Create Menu items and connect signals */
	data->menu_item_file_open = gtk_menu_item_new_with_label ("Test File Open");
	g_signal_connect (G_OBJECT (data->menu_item_file_open), "activate", G_CALLBACK (cb_example_file_open), data);

	data->menu_item_file_save = gtk_menu_item_new_with_label ("Test File Save");
	g_signal_connect (G_OBJECT (data->menu_item_file_save), "activate", G_CALLBACK (cb_example_file_save), data);

	data->menu_item_quit = gtk_menu_item_new_with_label ("Quit");
	g_signal_connect (G_OBJECT (data->menu_item_quit), "activate", G_CALLBACK (cb_example_quit), NULL);

	/* Append items to menu */
	gtk_menu_append (data->main_menu, data->menu_item_file_open);
	gtk_menu_append (data->main_menu, data->menu_item_file_save);
	gtk_menu_append (data->main_menu, gtk_separator_menu_item_new());
	gtk_menu_append (data->main_menu, data->menu_item_quit);

	hildon_window_set_menu(HILDON_WINDOW(data->window), GTK_MENU(data->main_menu));
	gtk_widget_show_all (GTK_WIDGET (data->main_menu));
}

void example_init (AppData * data)
{
	/* Create the hildon program and setup the title */
	data->program = HILDON_PROGRAM(hildon_program_get_instance());
	g_set_application_name("File Chooser Example");

	/* Create HildonWindow and set it to HildonProgram */
	data->window = HILDON_WINDOW(hildon_window_new());
	hildon_program_add_window(data->program, data->window);

	/* Add main vbox to appview */
	data->main_vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (data->window), data->main_vbox);

	/* Add label to main vbox */
	data->label = gtk_label_new ("File Chooser Example.\n\nClick on Menu for test list.");
	gtk_box_pack_start (GTK_BOX (data->main_vbox), data->label, TRUE, TRUE, 0);

        /* Connect signal to X in the upper corner */
        g_signal_connect(G_OBJECT(data->window), "delete_event",
          G_CALLBACK(cb_example_quit), data);

	gtk_widget_show_all (GTK_WIDGET(data->window));

	/* Create Menu */
	example_create_menu (data);
}


int main(int argc, char *argv[])
{
	AppData * data = g_new0 (AppData, 1);

	gtk_init(&argc, &argv);

	example_init (data);

	gtk_main();

	g_free (data);
    	return 0;
}
