/**
 * This file is part of maemo-examples package
 * 
 * Copyright (c) 2007 Nokia Corporation. All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE. */

#ifndef _EXAMPLE_COMMON_H_
#define _EXAMPLE_COMMON_H_

#include <hildon/hildon-banner.h>
#include <hildon/hildon-program.h>
#include <gtk/gtk.h>

/* Initialize the gui by creating a HildonProgram
 * and HildonWindow */
void example_gui_initialize(
		HildonProgram **program,
		HildonWindow **window,
		int *argc, char ***argv,
		gchar *example_name)
{
	g_thread_init(NULL);

	/* Initialize GTK+ */
	gtk_init(argc, argv);

	/* Create HildonProgram and set application name */
	*program = HILDON_PROGRAM(hildon_program_get_instance());
	g_set_application_name(example_name);

	/* Create the toplevel HildonWindow */
	*window = HILDON_WINDOW(hildon_window_new());

	/* Connect destroying of the main window to gtk_main_quit */
	g_signal_connect(G_OBJECT(*window), "delete_event",
			G_CALLBACK(gtk_main_quit), NULL);
}

void example_gui_run(HildonProgram *program,
			HildonWindow *window)
{
	/* Show the window and widgets it contains
	 * and go to the main loop. */
	gtk_widget_show_all(GTK_WIDGET(window));
	gtk_main();
}



#endif
