/**
 * This file is part of maemo-examples package
 * 
 * Copyright (c) 2007 Nokia Corporation. All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE. */


#include <libosso.h>
#include <unistd.h>

int main(int argc, char *argv[])
{
    osso_context_t *osso_context;
    osso_rpc_t retval;
    osso_return_t ret;

    /* Initialize maemo application */
    osso_context = osso_initialize("backup", "0.0.2", TRUE, NULL);

    /* Check that initialization was ok */
    if (osso_context == NULL) {
        return OSSO_ERROR;
    }

    g_print("Sending backup_start...\n");

    ret = osso_rpc_run(osso_context,
		       "com.nokia.backup",
		       "/com/nokia/backup",
		       "com.nokia.backup",
		       "backup_start", &retval, DBUS_TYPE_INVALID);
    osso_rpc_free_val(&retval);
    
    g_print("Waiting 10 seconds to send backup_finish...\n");
    sleep(10);
    g_print("Sending backup_finish...\n");
    
    ret = osso_rpc_run(osso_context,
		       "com.nokia.backup",
		       "/com/nokia/backup",
		       "com.nokia.backup",
		       "backup_finish", &retval, DBUS_TYPE_INVALID);
    osso_rpc_free_val(&retval);

    osso_deinitialize(osso_context);
    
    return 0;
}
