#ifndef _HTTPPORTALLOCATOR_H_
#define _HTTPPORTALLOCATOR_H_

#include "talk/p2p/client/basicportallocator.h"
#include "talk/base/asynchttprequest.h"

namespace cricket {
  class SignalThread;
}

namespace cricket {

class HttpPortAllocator : public BasicPortAllocator {
public:
  HttpPortAllocator(cricket::NetworkManager* network_manager, const std::string &user_agent);
  virtual ~HttpPortAllocator();

  virtual PortAllocatorSession *CreateSession(const std::string &name);
  void SetStunHosts(const std::vector<cricket::SocketAddress> &hosts) {stun_hosts_ = hosts;}
  void SetRelayHosts(const std::vector<std::string> &hosts) {relay_hosts_ = hosts;}
  void SetRelayToken(const std::string &relay) {relay_token_ = relay;}
  std::string relay_token() const { return relay_token_; }
private:
  std::vector<cricket::SocketAddress> stun_hosts_;
  std::vector<std::string> relay_hosts_;
  std::string relay_token_;
  std::string agent_;
};

class RequestData;

class HttpPortAllocatorSession : public BasicPortAllocatorSession {
 public:
  HttpPortAllocatorSession(HttpPortAllocator *allocator,
                           const std::string &name,
			   const std::vector<cricket::SocketAddress> &stun_hosts,
			   const std::vector<std::string> &relay_hosts,
			   const std::string &relay,
			   const std::string &agent);
  ~HttpPortAllocatorSession() { if (request_ != NULL) request_->StopWork(); };

protected:
  virtual void GetPortConfigurations();

private:
  std::vector<std::string> relay_hosts_;
  std::vector<cricket::SocketAddress> stun_hosts_;
  std::string relay_token_;
  std::string agent_;
  cricket::AsyncHttpRequest *request_;

  void OnRequestDone(cricket::SignalThread* request);
  HttpPortAllocator* http_allocator() {
    return static_cast<HttpPortAllocator*>(allocator());
  }
  int attempts_;
};

} // namespace cricket

#endif // _XMPPPORTALLOCATOR_H_
