/**
 * @file person-list.h Person list
 *
 * Copyright (C) 2004-2006 Christian Hammond.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#ifndef _GALAGOD_PERSON_LIST_H_
#define _GALAGOD_PERSON_LIST_H_

#include <libgalago/galago.h>
#include "coco.h"
#include "meta-person.h"

void galagod_people_add(GalagoPerson *person);
void galagod_people_remove(GalagoPerson *person);

void galagod_people_remove_with_coco(GalagodCoCo *coco);

void galagod_people_add_meta_person(GalagodMetaPerson *meta_person);
void galagod_people_remove_meta_person(GalagodMetaPerson *meta_person);

void galagod_people_account_added(GalagoPerson *person);

const GList *galagod_people_get_meta_people(void);
size_t galagod_people_get_meta_person_count(void);

GalagodMetaPerson *galagod_people_get_meta_person(const char *id);
GalagodMetaPerson *galagod_people_get_me(void);

GalagodMetaPerson *galagod_people_find_with_account(
	const GalagoAccount *account);

void galagod_people_init(void);
void galagod_people_uninit(void);

#endif /* _GALAGOD_PERSON_LIST_H_ */
