/*
 * UPnP Browser for Maemo
 *
 * interface.h
 *
 * Copyright 2005 Nokia Corporation. All rights reserved.
 *
 * This is licensed under BSD-style license,
 * see file COPYING.
 */

#ifndef INTERFACE_H
#define INTERFACE_H

#include "settings.h"

#include <gtk/gtk.h>
#ifdef MAEMO
#include <osso-mime.h>
#include <libosso.h>
#endif

typedef struct _UPnPBrowserWidgets
{
	GtkWidget* app;
	GtkWidget* appview;

	GtkWidget* menu;
	
	GtkTooltips* tips;

	/** VPaned that holds the hpaned's */
	GtkWidget* vpaned;

	/** hpaned that holds the file browser windows */
	GtkWidget* hpaned;

	/** VPaned that holds the toolbar(s) */
	GtkWidget* toolbar_vbox;
	
	/** Device view */
	GtkWidget* device_view;
	/** Device view's scrolled window */
	GtkWidget* device_scrolled_window;

	/** Folder view */
	GtkWidget* folder_view;
	/** Folder view's scrolled window */
	GtkWidget* folder_scrolled_window;
	/** Model for folder view */
	GtkTreeStore* folder_model;

	/** Filter to show only container columns (device view) */
	GtkTreeModel *container_filter;
	/** Filter to show flat file list (folder view) */
	GtkTreeModel *file_filter;
	
	GtkToolItem *volume_dec_button;
	GtkToolItem *mute_button;
	GtkToolItem *volume_inc_button;

	/** Toolbar that holds the "Now Playing" widgets */
	GtkWidget* now_playing_bar;

	/** Toolbar */
	GtkWidget* toolbar;

	/** The combo that holds available renderers */
	GtkWidget* renderer_combo;
	/** Model for renderer combo */
	GtkListStore* renderer_model;

	/* Renderer preset menu button */
	GtkToolItem *presets_button;
	
	/** The widget showing the current track on the selected renderer */
	GtkWidget* now_playing_text_view;
	/** The text buffer for the now playing text view */
	GtkTextBuffer* now_playing_text_buffer;

	/* Timeout handle for the last playing */
	guint now_playing_timeout;

	/** Current volume */
	gint volume;
	/** Current mute status */
	gboolean mute;

	/** Seek bar */
	GtkWidget* seek_bar;
	gulong seek_bar_signal;

#ifdef MAEMO
	osso_context_t *osso;
#endif

	UPnPBrowserSettings* settings;

} UPnPBrowserWidgets;

/*****************************************************************************
 * Functions
 *****************************************************************************/
/**
 * Top-level widget creation
 */
int create_widgets();

/**
 * Create application menu
 */
int create_menu();

/**
 * Create toolbar
 */
int create_toolbar();

/*****************************************************************************
 * Callbacks
 *****************************************************************************/

/**
 * Callback for "Download" menu item
 */
void download_clicked();

/**
 * Callback for "Download" menu item
 */
void settings_clicked();

/**
 * Callback for "Close" menu item
 */
void close_clicked();

/**
 * Callback to update devices
 */
void update_clicked();

/**
 * Callback for renderer presets button
 */
void renderer_presets_clicked();

/**
 * Callback for Volume Decrease button
 */
void volume_decrease_clicked();

/**
 * Callback for Mute button
 */
void mute_clicked();

/**
 * Callback for Volume Increase button
 */
void volume_increase_clicked();

/**
 * Callback for Previous button
 */
void prev_clicked();

/**
 * Callback for Play button
 */
void play_clicked();

/**
 * Callback for Pause button
 */
void pause_clicked();

/**
 * Callback for Stop button
 */
void stop_clicked();

/**
 * Callback for Next button
 */
void next_clicked();

/**
 * Callback for playlist button
 */
void playlist_clicked();

/**
 * Callback for playlist add button
 */
void playlist_add_clicked();

/**
 * Callback for playlist add all button
 */
void playlist_add_all_clicked();

/**
 * Seek bar move signal
 */
void seek_bar_move(GtkRange* range, gpointer user_data);

#endif
