/* Certificate Management library
 * 
 * Copyright (C) 2005 Nokia. All rights reserved.
 * Author: Ed Bartosh <Eduard.Bartosh@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <string.h>

#include "test.h"

void free_array_EVP_PKEY(EVP_PKEY ** arr)
{
    if (arr)
    {
        int i;
        for (i = 0; arr[i] != NULL; i++)
        {
            EVP_PKEY_free(arr[i]);
        }

        g_free(arr);
    }
}

X509 *test_load_cert(char *filename)
{
    X509 *x = NULL;
    FILE *fp;

    if (!(fp = fopen(filename, "r")))
    {
        return NULL;
    }

    x = PEM_read_X509(fp, NULL, NULL, NULL);

    fclose(fp);

    return x;
}

EVP_PKEY * test_load_private_key(char *filename, unsigned char *password)
{
    EVP_PKEY * x = NULL;
    FILE *fp;

    if (!(fp = fopen(filename, "r")))
    {
        return NULL;
    }

    x = PEM_read_PrivateKey(fp, NULL, NULL, password);

    fclose(fp);

    return x;
}

EVP_PKEY * test_load_public_key(char *filename)
{
    EVP_PKEY * x = NULL;
    FILE *fp;

    if (!(fp = fopen(filename, "r")))
    {
        return NULL;
    }

    x = PEM_read_PUBKEY(fp, NULL, NULL, NULL);

    fclose(fp);

    return x;
}

void printMsg(char *prefix, char *message)
{
    printf("%s\t%s\n", prefix, message);
}

void printOk(char *message)
{
    printMsg("OK", message);
}


void printErr(char *message)
{
    printMsg("ERROR", message);
}

void free_stack_X509(STACK_OF(X509) * list)
{
    if (list)
    {
        int i;
        for (i = 0; i < sk_X509_num(list); i++)
        {
            X509_free(sk_X509_value(list, i));
        }
        sk_X509_free(list);
    }
}
