/* Certificate Management library
 * 
 * Copyright (C) 2005 Nokia. All rights reserved.
 * Author: Ed Bartosh <Eduard.Bartosh@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/**
   @file cst_crl.h

   Crypt functions and structures
*/

#ifndef CST_CRL_H_
#define CST_CRL_H_

#include "cst.h"
#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
    Init crl idx
*/
    int cst_crl_list_init(CST * st);

/**
    Destroy crl idx
*/
    int cst_crl_list_destroy(CST * st);

/**
    Append crl to storage
*/
    int crl_append(CST * st, X509_CRL * crl);

/**
    Import CRL from file
*/
    int crl_import(CST * st, FILE * fp, const unsigned char *password);
    int crl_import_DER(CST * st, FILE * fp);

/**
    Get X509 structure
*/
    X509_CRL *crl_get_X509_CRL(CST * st,  const t_seqnum crlID);

/**
    Check signature under importe CRL
*/
    gboolean crl_check_sign(CST * st, X509_CRL * xcrl);


    t_seqnum cst_next_crl_uid(CST * st);

    void initial_scan_db_crl(CST * st, DBT * key, DBT * data);

#ifdef __cplusplus
}
#endif
#endif                          /* CST_CRL_H_ */
