#!/bin/sh

msg()
{
    echo -en "$1"
}
    
die(){
    msg "$1\n"
    exit 1
}
	    
	    
[ -z "$1" ] && die "Missing argument"

pushd $1

cd mimetypes

#text/html                       qgn_list_gene_bookmark
#text/sgml                       qgn_list_gene_bookmark
#text/xml                        qgn_list_gene_bookmark
#text/css                        qgn_list_gene_bookmark
#text/x-dtd                      qgn_list_gene_bookmark

for i in text-html text-sgml text-xml text-css text-x-dtd; do 
 ln -s ../hildon/qgn_list_gene_bookmark.png gnome-mime-$i.png
done


#audio/mp3                       qgn_list_gene_music_file
#audio/wav                       qgn_list_gene_music_file
#audio/mpegurl                   qgn_list_gene_music_file
#audio/x-wav                     qgn_list_gene_music_file
#audio/x-mp3                     qgn_list_gene_music_file
#audio/mpeg                      qgn_list_gene_music_file
#audio/x-mpeg                    qgn_list_gene_music_file
#audio/x-amr                     qgn_list_gene_music_file
#audio/x-m4a                     qgn_list_gene_music_file
#audio/x-pn-realaudio            qgn_list_gene_music_file
#audio/x-mp2                     qgn_list_gene_music_file (bug 15049)
#audio/x-ms-wma                  qgn_list_gene_music_file (bug 23874)

for i in audio-mp3 audio-wav audio-mpegurl audio-x-wav audio-x-mp3 audio-mpeg audio-x-mpeg audio-x-amr audio-x-m4a audio-x-pn-realaudio audio-x-mp2 audio-x-ms-wma; do 
 ln -s ../hildon/qgn_list_gene_music_file.png gnome-mime-$i.png
done


#image/bmp                       qgn_list_gene_image_file
#image/gif                       qgn_list_gene_image_file
#image/jpeg                      qgn_list_gene_image_file
#image/png                       qgn_list_gene_image_file
#image/tiff                      qgn_list_gene_image_file
#image/svg+xml                   qgn_list_gene_image_file
#image/x-ico                     qgn_list_gene_image_file
#image/wbmp                      qgn_list_gene_image_file
#image/note.png                  qgn_list_gene_image_file

for i in image-bmp image-gif image-jpeg image-png image-tiff image-svg+xml image-x-ico image-wbmp image-note.png; do
 ln -s ../hildon/qgn_list_gene_image_file.png gnome-mime-$i.png
done


#video/mpeg                      qgn_list_gene_video_file
#video/3gpp                      qgn_list_gene_video_file
#video/x-avi                     qgn_list_gene_video_file
#video/x-msvideo                 qgn_list_gene_video_file
#video/x-real                    qgn_list_gene_video_file
#application/vnd.rn-realmedia    qgn_list_gene_video_file
#video/mp4                       qgn_list_gene_video_file (bug 25394)

for i in video-mpeg video-3gpp video-x-avi video-x-msvideo video-x-real application-vnd.rn-realmedia video-mp4; do
 ln -s ../hildon/qgn_list_gene_video_file.png gnome-mime-$i.png
done

#text/txt                        qgn_list_gene_note_plain
#text/plain                      gqn_list_gene_note_plain
#text/note.html                  qgn_list_gene_note
#text/note                       qgn_list_gene_note
#application/pdf                 qgn_list_gene_pdffile
#application/x-deb               qgn_list_gene_debian
#application/x-debian-package    qgn_list_gene_debian
#sketch/png                      qgn_list_gene_sketch_file (bug 16125)
#audio/x-mpegurl                 qgn_list_gene_playlist (bug 16771)
#application/x-certman           qgn_list_gene_certificate (bug 16771)
#application/game                qgn_list_filesys_game_file (bug 16771)
#audio/x-scpls                   qgn_list_gene_playlist (bug 18335)

ln -s ../hildon/qgn_list_gene_note_plain.png gnome-mime-text-txt.png
ln -s ../hildon/qgn_list_gene_note_plain.png gnome-mime-text-plain.png
ln -s ../hildon/qgn_list_gene_note.png gnome-mime-text-note.png
ln -s ../hildon/qgn_list_gene_note.png gnome-mime-text-note.html.png
ln -s ../hildon/qgn_list_gene_pdffile.png gnome-mime-application-pdf.png
ln -s ../hildon/qgn_list_gene_debian.png gnome-mime-application-x-deb.png
ln -s ../hildon/qgn_list_gene_debian.png gnome-mime-application-x-debian-package.png
ln -s ../hildon/qgn_list_gene_sketch_file.png gnome-mime-sketch-png.png
ln -s ../hildon/qgn_list_gene_playlist.png gnome-mime-audio-x-mpegurl.png
ln -s ../hildon/qgn_list_gene_playlist.png gnome-mime-audio-x-scpls.png
ln -s ../hildon/qgn_list_gene_certificate.png gnome-mime-application-x-certman.png
ln -s ../hildon/qgn_list_filesys_game_file.png gnome-mime-application-game.png

# Unknown
#application/x-javascript        
#application/x-chess-pgn

popd
