/*
 * This file is part of multimedia framework
 *
 * Copyright (C) 2007 Nokia Corporation. All rights reserved.
 *
 * Contact: Stefan Kost <stefan.kost@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef OSSO_MULTIMEDIA_INTERFACE_H
#define OSSO_MULTIMEDIA_INTERFACE_H


#define OSSO_MULTIMEDIA_SERVICE "com.nokia.osso_media_server"

#define OSSO_MULTIMEDIA_SOUND_INTERFACE "com.nokia.osso_media_server.sound"

#define OSSO_MULTIMEDIA_OBJECT_PATH "/com/nokia/osso_media_server"

/* System sound service */

/* DBUS_TYPE_STRING, URL; DBUS_TYPE_INT32, priority */
#define OSSO_MULTIMEDIA_PLAY_SOUND_REQ "play_sound"

/* no args */
#define OSSO_MULTIMEDIA_STOP_SOUND_REQ "stop"

/* DBUS_TYPE_BOOLEAN */
#define OSSO_MULTIMEDIA_SET_LOOP_REQ "set_loop"

/* DBUS_TYPE_DOUBLE, 0.0 - 1.0 */
#define OSSO_MULTIMEDIA_SET_VOLUME_REQ "set_volume"

#define OSSO_MULTIMEDIA_EOS_SIGNAL "end_of_stream"

#endif /* OSSO_MULTIMEDIA_INTERFACE_H */

