#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdlib.h>
#include <dbus/dbus-glib.h>

int main(int argc, char *argv[])
{
    DBusGConnection *conn;
    GError *err = NULL;
    const gchar **devs = NULL;
    DBusGProxy *hci0;

    g_type_init();

    conn = dbus_g_bus_get(DBUS_BUS_SYSTEM, &err);
    if (err != NULL) {
        g_printerr("Connecting to system bus failed: %s\n", err->message);
        g_error_free(err);
        exit(EXIT_FAILURE);
    }

    hci0 = dbus_g_proxy_new_for_name(conn, "org.bluez", "/org/bluez/hci0",
                                     "org.bluez.Adapter");

    dbus_g_proxy_call(hci0, "ListBondings", &err, G_TYPE_INVALID,
                      G_TYPE_STRV, &devs, G_TYPE_INVALID);
    if (err != NULL) {
        g_printerr("ListBondings failed: %s\n", err->message);
        g_error_free(err);
        exit(EXIT_FAILURE);
    }

    while (*devs) {
        g_print("Removing bonding for %s\n", *devs);
        dbus_g_proxy_call(hci0, "RemoveBonding", NULL, G_TYPE_STRING, *devs,
                G_TYPE_INVALID);
        devs++;
    }

    exit(EXIT_SUCCESS);
}
