#!/bin/sh

AF_DEFINES="/etc/osso-af-init/af-defines.sh"
PRODUCT_NAME="Nokia Tablet"

if [ "$OSSO_PRODUCT_NAME" ]; then
	PRODUCT_NAME="Nokia $OSSO_PRODUCT_NAME"
elif [ -f $AF_DEFINES ]; then
	. $AF_DEFINES
	if [ "$OSSO_PRODUCT_NAME" ]; then
		PRODUCT_NAME="Nokia $OSSO_PRODUCT_NAME"
	fi
fi

dbus-send --print-reply --system --dest=org.bluez /org/bluez/hci0 org.bluez.Adapter.SetMode string:connectable > /dev/null

dbus-send --print-reply --system --dest=org.bluez /org/bluez/hci0 org.bluez.Adapter.SetName string:"$PRODUCT_NAME" > /dev/null
dbus-send --print-reply --system --dest=org.bluez /org/bluez/hci0 org.bluez.Adapter.SetDiscoverableTimeout uint32:0 > /dev/null
dbus-send --print-reply --system --dest=org.bluez /org/bluez/hci0 org.bluez.Adapter.SetMode string:off > /dev/null
