#!/bin/sh

if [ -z "$SUDO_COMMAND" ]; then
	sudo /etc/osso-backup/restore.d/always/bluez-restore.sh $@
	exit 0
fi

PATH="/sbin:/usr/sbin:/bin:/usr/bin"

if [ "$1" ]; then
	if [ -z "`grep /var/lib/bluetooth $1`" ] && [ -z "`grep /etc/bluetooth/name $1`" ]; then
		exit 0;
	fi
fi

MY_BDA=`cat /sys/class/bluetooth/hci0/address`

[ -z "$MY_BDA" ] && exit 1

CORRECT_DIR="/var/lib/bluetooth/$MY_BDA"

OLD_DIR=`ls -d /var/lib/bluetooth/*|grep -v $MY_BDA|head -n 1`

if [ "$OLD_DIR" ]; then
	rm -rf $CORRECT_DIR
	mv $OLD_DIR $CORRECT_DIR
fi

dbus-send --system --print-reply --dest=org.bluez /org/bluez/hci0 org.bluez.Adapter.SetMode string:connectable > /dev/null

NAME=""

if [ "$1" ] && [ "`grep /etc/bluetooth/name $1`" ] && [ ! -f "$CORRECT_DIR/config" ]; then
	NAME=`cat /etc/bluetooth/name`
fi

if [ -z "$NAME" ] && [ -f "$CORRECT_DIR/config" ]; then
	NAME=`egrep ^name $CORRECT_DIR/config|sed 's/^name //'`
fi

if [ "$NAME" ]; then
	dbus-send --print-reply --system --dest=org.bluez /org/bluez/hci0 org.bluez.Adapter.SetName string:"$NAME" > /dev/null
fi

MODE=""

if [ -f "$CORRECT_DIR/config" ]; then
	MODE=`egrep ^mode $CORRECT_DIR/config|awk '{ print $2 }'`
fi

if [ "$MODE" ]; then
	dbus-send --print-reply --system --dest=org.bluez /org/bluez/hci0 org.bluez.Adapter.SetMode string:$MODE > /dev/null
fi

