/**
 * @file ui_itemlist.c Item list/view handling
 *  
 * Copyright (C) 2004 Lars Lindner <lars.lindner@gmx.net>
 * Copyright (C) 2004 Nathan J. Conrad <t98502@users.sourceforge.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <langinfo.h>
#include <string.h>
#include <osso-log.h>

#include <settings.h>

#include "support.h"
#include "callbacks.h"
#include "common.h"
#include "debug.h"
#include "feed.h"
#include "item.h"
#include "htmlview.h"
#include "conf.h"
#include "ui_itemlist.h"
#include "ui_mainwindow.h"

/* tvh: IMPORTANT NOTE:
	Many of ui_itemlist calls here are relavent only iin the 
	3 paned mode in liferea. Therefore in newsreader, most of these are not needed
*/
extern gboolean itemlist_mode;

extern AppData *app_data;

//guint rss_search_found = 0;

/* displayed_fp should almost always be the same as selected_fp in ui_feedlist */
nodePtr displayed_node = NULL;

/* tvh: Return the time_t in string format 
    Used in the 3 pane mode, most likely.
    A TODO: Either remove this, or move it to somewhere else, definitely not here
*/
gchar *ui_itemlist_format_date(time_t t)
{
    gchar *tmp = FALSE;
    gchar *timestr = FALSE;
    gchar *time_string = NULL;
    gchar *date_string = NULL;
//    ULOG_DEBUG("\n\n>>>>>>>>>>>>>>>>>>>>ui_itemlist_format_date<<<<<<<<<<<<<<<<<<,\n\n");
    time_t local_time = t;

    time_string = get_localized_time(local_time);
    date_string = get_localized_date(local_time, TRUE);
    
    //fprintf(stderr, "tvh: get time in ui_itemlist.c is done \n\n");
    tmp = g_strconcat(date_string, " ", time_string, NULL);
    
    g_free(time_string);
    g_free(date_string);
    
    timestr = g_locale_to_utf8(tmp, -1, NULL, NULL, NULL);
    g_free(tmp);

    return timestr;
}

void ui_itemlist_clear(void)
{
   AppUIData *app_ui_data = NULL;

    ULOG_DEBUG(__FUNCTION__);
    displayed_node = NULL;
    gtkhtml_stop();
    ULOG_DEBUG("Setting feed displayed to FALSE");
    
    g_assert(app_data != NULL);
    g_assert(app_data->app_ui_data != NULL);
    
    app_ui_data = app_data->app_ui_data;
    
    free_find_string();/*TODO: it needs to be cached doesn't it? */
    app_ui_data->feed_displayed = FALSE;
}

/* Function which is called when the contents of currently
   selected object (feed or item) is updated or if the 
   selection has changed and initial display is requested. 
   
   What the function prints to the HTML view depends on the
   focussed widget. If feedlist is selected feed info is printed.
   If itemlist is selected the selected items content is shown. 
   If anything other is focussed nothing is printed to avoid
   disturbing the user. */

void ui_itemlist_display(nodePtr node)
{
    gtkhtml_stop();

    displayed_node = node;
    ui_htmlview_write(app_data->app_ui_data->html_scrollpane,NULL,NULL, node); //:D No need

    ui_feedlist_update();
    /*tvh: bug 22893 : no need to update applet? do we? TODO*/
    //ui_feedlist_update_applet();
}

void ui_itemlist_load_feed(feedPtr fp)
{
    g_assert(fp != NULL);
    if (!conf_keep_feeds_in_memory) {
    debug0(DEBUG_CACHE, "unloading everything...");
    ui_feedlist_do_for_all(NULL,
                   ACTION_FILTER_FEED |
                   ACTION_FILTER_DIRECTORY, feed_unload);
    }
    feed_load(fp);
}

/* search append */
void ui_itemlist_search_append(itemPtr ip)
{

    if (app_data->app_ui_data->search_mode!= SFM_SEARCH)
        return;
    ui_htmlview_render_item(ip);
    //search can still be interrupted after appending one item
    //if (app_data->app_ui_data->search_mode!= SFM_SEARCH)
    //    return;
    if (!item_get_read_status(ip)) {
        item_set_read(ip);
    }

    //it's done in vfolder.c
    //app_data->app_ui_data->rss_search_found ++;//= rss_search_found + 1;
    ULOG_DEBUG("ui_itelist search append...constructing search view with \
        rss_search_found = %d", app_data->app_ui_data->rss_search_found);
    ui_mainwindow_construct_search_view();
    ui_update();
}

void ui_itemlist_search_init()
{
    app_data->app_ui_data->rss_search_found = 0;
    if (!conf_keep_feeds_in_memory) {
        debug0(DEBUG_CACHE, "unloading everything...");
        ui_feedlist_do_for_all(NULL,
                       ACTION_FILTER_FEED |
                       ACTION_FILTER_DIRECTORY, feed_unload);
    }
}

/* Load and display a node. Can be a normal feed.
    Can be a searchFeed
 */

void ui_itemlist_load(nodePtr node)
{
    ULOG_DEBUG(__FUNCTION__);

    g_assert(NULL != node);

    /* free old and instruct getItemStore() to create new itemstore */
    ULOG_DEBUG("\nui_itenlist_load : ++++++++++loading node +++++++++++\n");
    /* ui_itemlist_clear() resets this */
    displayed_node = node;

    ULOG_DEBUG("Feed displayed set to TRUE");
    
    g_assert(app_data != NULL);
    g_assert(app_data->app_ui_data != NULL);
    
    app_data->app_ui_data->feed_displayed = TRUE;
        
    /* Add the new items */
    if ((node == NULL) || (FST_FOLDER == node->type)) {
        ui_feedlist_do_for_all(node,
                   ACTION_FILTER_FEED |
                   ACTION_FILTER_DIRECTORY,
                   ui_itemlist_load_feed);
    } else if ((FST_FEED == node->type) || (FST_VFOLDER == node->type)) {
        ui_itemlist_load_feed((feedPtr) node);
    }

    ui_itemlist_display(node);
}



//ALL the liferea & non-rss stuff commented out here 

/* Liferea is able to remove items, not news reader */
/*
void on_remove_items_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    feedPtr fp = NULL;

    if ((NULL != displayed_node) && (FST_FEED == displayed_node->type)) {
    fp = (feedPtr) displayed_node;
    ui_itemlist_clear();
    feed_remove_items(fp);
    ui_feedlist_update();
    }
}
*/
/** If an item list is currently being displayed, scroll to the top
  */
/*
void ui_itemlist_scroll_to_top()
{

    //GtkTextIter   target_iter;
    //GtkTextView   *text_view;
    
    if (displayed_node != NULL)
    {
    //    text_view = GTK_TEXT_VIEW(ui_htmlview_get_buffer());
        
    //gtk_text_view_get_line_at_y (text_view,
                                     &target_iter,
                                     0,
                                     NULL);
    
    //gtk_text_view_scroll_to_iter (text_view,
            &target_iter,
            0.25,
            FALSE,
            0,
            0);
    }
}
*/


/************************************************************************/
/*                        PRIVATE FUNCTIONS                             */
/************************************************************************/

/** Sort function for the item list date column 
  *
  * @param model the tree model where the times are found
  * @param a an iterator for the first time
  * @param b an iterator for the second time
  * @param user_data not used
  */
/*
static gint timeCompFunc(GtkTreeModel * model, GtkTreeIter * a,
             GtkTreeIter * b, gpointer user_data)
{
    time_t timea, timeb;

    g_assert(model != NULL);
    g_assert(a != NULL);
    g_assert(b != NULL);
    gtk_tree_model_get(model, a, IS_TIME, &timea, -1);
    gtk_tree_model_get(model, b, IS_TIME, &timeb, -1);

    return timeb - timea;
}
*/
/** Frees ui data for the given item
  *
  * @param model the tree mdoel where the item is found
  * @param path not used
  * @param iter an iterator for the wanted item
  * @param data not used
  */
/*
static gboolean ui_free_item_ui_data_foreach(GtkTreeModel * model,
                         GtkTreePath * path,
                         GtkTreeIter * iter,
                         gpointer data)
{
    itemPtr ip = FALSE;
    gtk_tree_model_get(model, iter, IS_PTR, &ip, -1);

    // The ui_free_item_ui_data method cannot be used because it
    //   modifies the tree store and messes up the
    //   gtk_tree_store_foreach function. 
    
    if(ip != NULL)
    {
        if(ip->ui_data)
        g_free(ip->ui_data);

        ip->ui_data = NULL;
    }

    return FALSE;
}
*/
/** Updates an item's attributes
  *
  * @param iter an iterator for the item
  */
/*
static void ui_update_item_from_iter(GtkTreeIter * iter)
{
    GtkTreeStore *itemstore = getItemStore();
    gpointer ip = NULL;
    gchar *title = NULL, *label = NULL, *time_str = NULL, *esc_title = NULL, *tmp = NULL;
    gint time = 0;
    GdkPixbuf *pixbuf = NULL, *pixbuf2 = NULL;

    gtk_tree_model_get(GTK_TREE_MODEL(itemstore), iter,
               IS_PTR, &ip, IS_TITLE, &title, IS_TIME, &time, -1);

    // Icon 
    pixbuf = icons[ICON_RSS_NEWS_FEED];
    if (NULL != ((itemPtr) ip)->sourceFeed)
    pixbuf2 = ((itemPtr) ip)->sourceFeed->icon;
    else
    pixbuf2 = NULL;

    // Label 
    if (title != NULL) {
    // Here we have the following problem: a title string might contain 
    //   either escaped markup (which we should not escape again) or 
    //  non-markup text (which might contain ampersands, which must be
    //   escaped). We assume no mixed case! 

    esc_title = g_markup_escape_text(title, -1);

    esc_title = filter_title(esc_title);

    if (FALSE == item_get_read_status(ip)) {
        label =
        g_strdup_printf("<span weight=\"bold\">%s</span>",
                esc_title);
    } else {
        label = g_strdup_printf("%s", esc_title);
    }
    g_free(esc_title);
    } else {
    label = g_strdup("");
    }

    // Time 
    if (0 != time) {
    if (FALSE == item_get_read_status(ip)) {
        // the time value is no markup, so we escape it... 
        time_str = ui_itemlist_format_date((time_t) time);
        tmp = g_markup_escape_text(time_str, -1);
        g_free(time_str);
        time_str =
        g_strdup_printf("<span weight=\"bold\">%s</span>", tmp);
        g_free(tmp);
    } else {
        time_str = ui_itemlist_format_date((time_t) time);
    }
    } else {
    time_str = g_strdup("");
    }

    // Finish 'em... 
    gtk_tree_store_set(getItemStore(), iter,
               IS_LABEL, label,
               IS_TIME_STR, time_str,
               IS_ICON, pixbuf, IS_ICON2, pixbuf2, -1);
    g_free(time_str);
    g_free(title);
    g_free(label);
}
*/
/**
 * Appends the feed name / update time header to a feed textbuffer.
 * Tries to align update time to right margin.
 *
 * @param buffer to append header into
 * @param node to take feed information for header

 * tvh: not used in gtkhtml model so commented out
 */
/*
static void ui_itemlist_append_header(GtkTextBuffer * buffer, feedPtr node)
{
    GtkTextIter textIter;
    gchar *time_str = NULL;

    g_assert(NULL != buffer);
    g_assert(NULL != node);

    GtkTextTag *bold =
    gtk_text_buffer_create_tag(GTK_TEXT_BUFFER(buffer), NULL, "weight",
                   PANGO_WEIGHT_BOLD, NULL);
    GtkTextTag *justify_right =
    gtk_text_buffer_create_tag(GTK_TEXT_BUFFER(buffer), NULL,
                   "justification", GTK_JUSTIFY_RIGHT,
                   NULL);

    gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(buffer), &textIter);

    / Just in case node title has been deleted /
    gtk_text_buffer_insert_with_tags(GTK_TEXT_BUFFER(buffer),
                     &textIter,
                     node->title ? node->title : "", -1,
                     bold, NULL);

    gtk_text_buffer_insert(GTK_TEXT_BUFFER(buffer), &textIter, "  ", -1);

    if(node->lastPoll.tv_sec > 0)
    {
        time_str = ui_itemlist_format_date((time_t) node->lastPoll.tv_sec);

    
        gtk_text_buffer_insert_with_tags(GTK_TEXT_BUFFER(buffer),
                         &textIter, time_str, -1,
                         justify_right, NULL);

        g_free(time_str);
    }

    gtk_text_buffer_insert(GTK_TEXT_BUFFER(buffer), &textIter, "\n\n", -1);
}

*/
/************************************************************************/
/*                        PUBLIC FUNCTIONS                              */
/************************************************************************/
/*
void ui_itemlist_sort_column_changed_cb(GtkTreeSortable * treesortable,
                    gpointer user_data)
{
    gint sortColumn = 0;
    GtkSortType sortType;
    gboolean sorted = FALSE;

    if (displayed_node == NULL || disableSortingSaving != 0)
    return;

    sorted =
    gtk_tree_sortable_get_sort_column_id(treesortable, &sortColumn,
                         &sortType);
    if ((FST_FEED == displayed_node->type)
    || (FST_VFOLDER == displayed_node->type))
    feed_set_sort_column((feedPtr) displayed_node, sortColumn,
                 sortType == GTK_SORT_DESCENDING);
}
*/

/*
GtkTreeStore *getItemStore(void)
{
    gboolean order = FALSE;
    if (NULL == itemstore) {
    / set up a store of these attributes: 
       - item title
       - item label
       - item state (read/unread)           
       - pointer to item data
       - date time_t value
       - the type of the feed the item belongs to
       - feed icon
     /
    itemstore = gtk_tree_store_new(IS_LEN,
                       G_TYPE_INT,
                       G_TYPE_STRING,
                       G_TYPE_STRING,
                       G_TYPE_STRING,
                       GDK_TYPE_PIXBUF,
                       G_TYPE_POINTER,
                       G_TYPE_INT, GDK_TYPE_PIXBUF);
     
        if (checkConfValueExist(RSS_SETTINGS_NEWEST_POSTS_FIRST)== FALSE)
       setBooleanConfValue(RSS_SETTINGS_NEWEST_POSTS_FIRST, TRUE);

    order = getBooleanConfValue(RSS_SETTINGS_NEWEST_POSTS_FIRST);

    gtk_tree_sortable_set_sort_func(GTK_TREE_SORTABLE(itemstore),
                    IS_TIME, timeCompFunc, NULL, NULL);
    gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(itemstore),
                         IS_TIME,
                         order ? GTK_SORT_ASCENDING :
                         GTK_SORT_DESCENDING);
    }

    return itemstore;
}

*/

/*
void ui_update_item(itemPtr ip)
{
    g_assert(NULL != ip);
    if (ip->ui_data)
    ui_update_item_from_iter(&((ui_item_data *) ip->ui_data)->row);
}
*/
/*
void ui_update_itemlist()
{
    GtkTreeIter iter;

    g_assert(itemstore != NULL);

    if (gtk_tree_model_get_iter_first(GTK_TREE_MODEL(itemstore), &iter)) {
    do {
        ui_update_item_from_iter(&iter);
    } while (gtk_tree_model_iter_next
         (GTK_TREE_MODEL(itemstore), &iter));
    }

}
*/







/*
typedef struct ui_item_data {
    GtkTreeIter row;
} ui_item_data;
*/
//extern GdkPixbuf *icons[];

//static GtkTreeStore *itemstore = NULL;

//extern GtkWidget * gtkhtml_htmlview;
//static gint disableSortingSaving;
