/*
   This file is based on unfinished/experimental/abandoned sources from
   Liferea CVS. The original copyright notice is reproduced here:


   fallback HTML display module, which displays the item view
   contents in a text widget
   
   Copyright (C) 2004 Lars Lindner <lars.lindner@gmx.net>  

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <hildon-widgets/hildon-defines.h>
#include <osso-log.h>

#include <libxml/xmlerror.h>
#include <libxml/uri.h>
#include <libxml/parser.h>
#include <libxml/HTMLparser.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <errno.h>
#include <time.h>
#include "../common.h"
#include "../htmlview.h"
#include "../support.h"
#include "../callbacks.h"
#include "../update.h"
#include "../debug.h"
#include "../dbus.h"
#include "../appdata.h"

enum inside_modes {
    INSIDE_NOTHING = 0,
    INSIDE_LINK = 1,
    INSIDE_UNMARKED_HEADLINE = 2,
    INSIDE_MARKED_HEADLINE = 3,
    INSIDE_ITALIC = 4
};

extern GtkWidget *mainwindow;

static GtkWidget *itemView = NULL;
static GtkWidget *itemListView = NULL;
static GtkWidget *htmlwidget = NULL;
static GtkWidget *scrollpane = NULL;

static gfloat zoomLevel = 1.0;

extern AppData *app_data;

struct _parse_data {
    GtkTextBuffer *buffer;
    GtkTextView *view;
    int inside_mode;
    gchar *widget_text;
};

typedef struct _parse_data parse_data;

typedef struct saveForLater {
    itemPtr ip;
    GtkLabel *titleLabel;
} *saveForLaterPtr;

/*gboolean event_catcher(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	ULOG_DEBUG("Got event: %d", event->type);
	
	if(event->type == 7)
            return TRUE;
	return FALSE;
}*/

void headline_clicked_cb(GtkWidget * widget, GdkEventButton * event,
			 gpointer user_data)
{
    itemPtr ip = (itemPtr) user_data;
    gchar *url = NULL;
    
    ULOG_DEBUG("Headline clicked: %s", item_get_title(ip));

    g_assert(app_data != NULL);
    g_assert(app_data->app_ui_data != NULL);

    url = g_strdup(item_get_source(ip));
    
    if(url != NULL)
    {
        url = trim_whitespaces(url);
    
/*        ULOG_INFO("Trying to launch browser...");
        app_data->app_ui_data->source = url;
        app_data->app_ui_data->iap_action = OSSO_IAP_LAUNCH_WEB_BROWSER;
        osso_iap_connect(OSSO_IAP_ANY, OSSO_IAP_REQUESTED_CONNECT,
			app_data->app_ui_data);*/

        ULOG_INFO("Trying to launch browser...returned from call.");

    }
}

void send_as_email_clicked_cb(GtkWidget * widget, GdkEventButton * event,
			      gpointer user_data)
{
    itemPtr ip = (itemPtr) user_data;

    ULOG_DEBUG("Send as email clicked for item %ld", ip->nr);

    send_item_via_email(ip);
}

static gchar *get_title_markup(itemPtr ip);

void save_for_later_destroy_cb(GtkWidget * widget, gpointer user_data)
{
    g_assert(widget != NULL);
    g_assert(user_data != NULL);

    g_free(user_data);
}

/*
    Callback function for rss_save_for_later check button
    This button is displayed when displaying a feed,
                  be it a normal feed or a search feed. 

NOTES:
	**Old: feedPtr fp is rendered from displayed_node
	**Current: feedPtr fp is now rendered from itemPtr ip, 
     
*/
void save_for_later_clicked_cb(GtkWidget * widget, gpointer user_data)
{
    g_assert(NULL != widget);
    g_assert(NULL != user_data);
    feedPtr fp;
    gboolean mark;
    /* CHECK: what happens if the user clicks another feed and quickly also 
       save for later in the previous feed contents? selected feed might be already different than the one expected. */

/*	gulong *itemId = (gulong*)user_data;*/
    saveForLaterPtr sfl = (saveForLaterPtr) user_data;
    itemPtr ip = sfl->ip;
    g_assert(NULL != ip);
    ULOG_DEBUG("Save for later clicked. itemId = %ld", ip->nr);
    /*  If it's a vfolder, should refer to the original_fp to update the feed 
	in_the_feedlist	*NOT* the virtual folder used for search  */

    if  (FST_VFOLDER == feed_get_type(ip->fp))
    	fp = (feedPtr) ip->orig_fp;
    else 
	fp = (feedPtr ) ip->fp; 
    
    g_assert(NULL != fp);
    mark = !item_get_mark(ip);

    item_set_mark(ip, mark);

    if (mark) { 
	    feed_increase_mark_counter(fp);
	    if (feed_get_mark_counter(fp) == 1)
		ui_feedlist_update();
		
  	    ULOG_INFO("Item %ld is now marked.\n", ip->nr);
    } else {
	    feed_decrease_mark_counter(fp);
	    if (feed_get_mark_counter(fp) == 0)
		ui_feedlist_update();
	    ULOG_INFO("Item %ld is now unmarked.\n", ip->nr);
    }
    gchar *markup = get_title_markup(ip);
    gtk_label_set_markup(GTK_LABEL(sfl->titleLabel), markup);
    g_free(markup);

    /* FIXME: content area tags should be updated to reflect the change */
}


void unhtmlize_to_text_buffer_handleCharacters(void *user_data,
					       const xmlChar * string,
					       int length)
{
    GtkTextBuffer *buffer = ((parse_data *) user_data)->buffer;
    GtkTextIter iter;

    gtk_text_buffer_get_end_iter(buffer, &iter);
    gtk_text_buffer_insert(buffer, &iter, string, length);
}

/* Converts a UTF-8 strings containing any HTML stuff to 
   a string without any entities or tags containing all
   text nodes of the given HTML string. 
*/

static void unhtmlize_to_text_buffer(gchar * string,
				     parse_data * parsedata)
{
    g_assert(string != NULL);

    htmlSAXHandlerPtr sax_p = NULL;
    htmlParserCtxtPtr ctxt;

    string = utf8_fix(string);

    sax_p = g_new0(htmlSAXHandler, 1);
    sax_p->characters = unhtmlize_to_text_buffer_handleCharacters;

    parsedata->inside_mode = INSIDE_NOTHING;
    parsedata->widget_text = NULL;

    ctxt =
	htmlCreatePushParserCtxt(sax_p, parsedata, string, strlen(string),
				 "", XML_CHAR_ENCODING_UTF8);
    htmlParseChunk(ctxt, string, 0, 1);
    htmlFreeParserCtxt(ctxt);
    g_free(sax_p);
}

/* function to write HTML source given as a UTF-8 string */
void write_html(GtkWidget * widget, const gchar * string,
		const gchar * base)
{
    g_assert(htmlwidget != NULL);

    GtkTextBuffer *buffer =
	GTK_TEXT_BUFFER(gtk_text_view_get_buffer
			(GTK_TEXT_VIEW(htmlwidget)));

    g_assert(buffer != NULL);

    gtk_text_buffer_set_text(buffer, "", -1);

    if (string == NULL)
	return;

    parse_data *parsedata = g_new0(parse_data, 1);
    parsedata->buffer = buffer;
    parsedata->view = GTK_TEXT_VIEW(htmlwidget);

    unhtmlize_to_text_buffer((gchar *) string, parsedata);

    g_free(parsedata);
}

static void change_zoom_level(GtkWidget * scrollpane, gfloat zoomLevel)
{
}

static gfloat get_zoom_level(GtkWidget * scrollpane)
{
    return zoomLevel;
}

static void gtktextview_init()
{
}

static void gtktextview_deinit()
{
}

static void setupHTMLView(GtkWidget * mainwindow,
			  GtkWidget * scrolledwindow)
{

    if (NULL != htmlwidget)
	gtk_widget_destroy(htmlwidget);

    if (NULL != scrollpane)
	gtk_widget_destroy(scrollpane);

    scrollpane = gtk_scrolled_window_new(NULL, NULL);

    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollpane),
				   GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
    gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scrollpane),
					GTK_SHADOW_NONE);
    gtk_container_set_border_width(GTK_CONTAINER(scrollpane),
				   0/*HILDON_MARGIN_DEFAULT*/);

    /* create text view widget and pack it into the scrolled window */
    htmlwidget = gtk_text_view_new();
    
    gtk_container_add(GTK_CONTAINER(scrollpane), GTK_WIDGET(htmlwidget));
    gtk_text_view_set_editable(GTK_TEXT_VIEW(htmlwidget), FALSE);
    gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW(htmlwidget), FALSE);
    gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(htmlwidget),
				GTK_WRAP_WORD_CHAR);

    gtk_text_view_set_left_margin(GTK_TEXT_VIEW(htmlwidget),
				  HILDON_MARGIN_DEFAULT);
    gtk_text_view_set_right_margin(GTK_TEXT_VIEW(htmlwidget),
				  HILDON_MARGIN_DEFAULT);
    gtk_widget_show_all(scrollpane);

    gtk_text_view_set_pixels_inside_wrap(GTK_TEXT_VIEW(htmlwidget), 3);
    gtk_text_view_set_pixels_above_lines(GTK_TEXT_VIEW(htmlwidget), 4);
    gtk_text_view_set_pixels_below_lines(GTK_TEXT_VIEW(htmlwidget), 4);
    
    /*g_signal_connect(G_OBJECT(htmlwidget), "event",
                     G_CALLBACK(event_catcher),
                     NULL);*/
}

GtkWidget *gtktextview_new()
{
    setupHTMLView(NULL, NULL);
    return scrollpane;
}

void setHTMLViewMode(gboolean threePane)
{

    if (FALSE == threePane)
	setupHTMLView(mainwindow, itemListView);
    else
	setupHTMLView(mainwindow, itemView);

}

void setupHTMLViews(GtkWidget * mainwindow, GtkWidget * pane1,
		    GtkWidget * pane2, gint initialZoomLevel)
{

    itemView = pane1;
    itemListView = pane2;
    setHTMLViewMode(TRUE);
    if (0 != initialZoomLevel) {
	change_zoom_level(NULL,
			  ((gfloat) initialZoomLevel) / 100 - zoomLevel);
    }
}

/* launches the specified URL */
void launch_url(GtkWidget * widget, const gchar * url)
{

}

gboolean launch_inside_possible(void)
{
    return FALSE;
}

GtkWidget *textview_get_buffer()
{
    return htmlwidget;
}

/* Function scrolls down the item views scrolled window.
   This function returns FALSE if the scrolled window
   vertical scroll position is at the maximum and TRUE
   if the vertical adjustment was increased. */
gboolean gtktextview_scroll_pagedown(GtkWidget * scrollpane)
{
    GtkScrolledWindow *itemview;
    GtkAdjustment *vertical_adjustment;
    gdouble old_value;
    gdouble new_value;
    gdouble limit;
    
    itemview = GTK_SCROLLED_WINDOW(scrollpane);
    g_assert(NULL != itemview);
    vertical_adjustment = gtk_scrolled_window_get_vadjustment(itemview);
    old_value = gtk_adjustment_get_value(vertical_adjustment);
    new_value = old_value + vertical_adjustment->page_increment;
    limit = vertical_adjustment->upper - vertical_adjustment->page_size;
    if (new_value > limit)
	new_value = limit;
    gtk_adjustment_set_value(vertical_adjustment, new_value);
    gtk_scrolled_window_set_vadjustment(GTK_SCROLLED_WINDOW(itemview),
					vertical_adjustment);
    return (new_value > old_value);
}

static void append_to_buffer(GtkTextBuffer * buffer, const gchar * string)
{
    GtkTextIter iter;
    gtk_text_buffer_get_end_iter(buffer, &iter);
    gtk_text_buffer_insert(buffer, &iter, string, -1);
}

static gchar *get_title_markup(itemPtr ip)
{
    gchar *title =
	g_strdup(item_get_title(ip) == NULL ? "-" : item_get_title(ip));
    remove_newlines_and_extra_spaces(title);
    gchar *retval =
	g_markup_printf_escaped
	("<span foreground=\"%s\" underline=\"single\">%s</span>",
	 item_get_mark(ip) ? "red" : "blue", title);
    g_free(title);
    return retval;
}

static GtkLabel *append_title(GtkTextBuffer * buffer, itemPtr ip)
{
    GtkTextIter iter;

    gtk_text_buffer_get_end_iter(buffer, &iter);
    GtkTextChildAnchor *anchor =
	GTK_TEXT_CHILD_ANCHOR(gtk_text_buffer_create_child_anchor
			      (buffer, &iter));
    GtkWidget *child = gtk_label_new(NULL);

    char *markup = get_title_markup(ip);
    gtk_label_set_markup(GTK_LABEL(child), markup);
    g_free(markup);
/*  FIXME: TextView size may change */
/*	gtk_widget_set_size_request(GTK_WIDGET(child), 200, -1); */
    gtk_label_set_line_wrap(GTK_LABEL(child), TRUE);
    child = widget_alter_font_size(child, FONT_SIZE, TRUE, TRUE);
    gtk_widget_show(child);

    GtkEventBox *child_container = GTK_EVENT_BOX(gtk_event_box_new());
    gtk_container_add(GTK_CONTAINER(child_container), child);
    gtk_widget_show(GTK_WIDGET(child_container));

    gtk_text_view_add_child_at_anchor(GTK_TEXT_VIEW(htmlwidget),
				      GTK_WIDGET(child_container), anchor);

    gtk_text_buffer_insert(buffer, &iter, "\n", 1);

    g_signal_connect((gpointer) child_container, "button_press_event",
		     G_CALLBACK(headline_clicked_cb), ip);

    return GTK_LABEL(child);
}

static void append_actions(GtkTextBuffer * buffer, itemPtr ip,
			   GtkLabel * titleLabel)
{
    GtkTextIter iter;
    GtkWidget *hbox;
    GtkWidget *vbox;
    GtkWidget *alignment;
    GtkWidget *time_and_date;
    GtkWidget *save_for_later;
    GtkWidget *separator;
    GtkWidget *send;
    GtkWidget *time_and_date_width;
    gchar *tmp, *tmp2;
    gboolean two_line_mode = TRUE;
    GtkRequisition req_checkbutton; 
    
    g_assert(NULL != ip);
    g_assert(NULL != titleLabel);
    g_assert(NULL != buffer);
    
    /* CHECK: This is rather ugly, all of the action elements are different
     * height, so we create them all as anchors and set the anchors size
     * requisition height to a common value >=checkbox height.
     */
    gtk_text_buffer_get_end_iter(buffer, &iter);

    /* News item timestamp */
    time_and_date = gtk_label_new(NULL);
    gchar *time_str = ui_itemlist_format_date((time_t) ip->time);
    tmp = g_markup_escape_text(time_str, -1);
    tmp2 = g_strconcat(tmp," ",NULL);
    gtk_label_set_markup(GTK_LABEL(time_and_date), tmp2);
    widget_alter_font_size(time_and_date, FONT_SIZE, TRUE, FALSE);
    gtk_widget_show(GTK_WIDGET(time_and_date));
    
    /* This widget is only for calculating the width of the label declared before since
       calling gtk_widget_size_request on the widget causes some weird behaviour. The
       text seems to be replaced by an ellipse :S */
    time_and_date_width = gtk_label_new(NULL);
    gtk_label_set_markup(GTK_LABEL(time_and_date_width), tmp2);
    widget_alter_font_size(time_and_date_width, FONT_SIZE, TRUE, FALSE);
            
    g_free(tmp);
    g_free(tmp2);
    g_free(time_str);
      
    alignment = gtk_alignment_new(0, 0.5, 0, 0);
    gtk_widget_show(alignment);

    gtk_container_add(GTK_CONTAINER(alignment), time_and_date);
    
    GtkTextChildAnchor *anchor =
	GTK_TEXT_CHILD_ANCHOR(gtk_text_buffer_create_child_anchor
			      (buffer, &iter));

    /* Save for later checkbox */
    save_for_later = gtk_label_new(NULL);
    gtk_widget_show(GTK_WIDGET(save_for_later));
    tmp =
	g_strdup_printf("<span foreground=\"blue\" underline=\"single\">%s</span>",
			_("rss_ia_save_for_later"));
    gtk_label_set_markup(GTK_LABEL(save_for_later), tmp);
    g_free(tmp);
    gtk_label_set_use_underline(GTK_LABEL(save_for_later), TRUE);
    widget_alter_font_size(save_for_later, FONT_SIZE, TRUE, FALSE);
    gtk_widget_show(GTK_WIDGET(save_for_later));

    GtkCheckButton *check_button =
	GTK_CHECK_BUTTON(gtk_check_button_new());

    GTK_TOGGLE_BUTTON(check_button)->active = item_get_mark(ip);
    gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(check_button), TRUE);
    gtk_button_set_relief(GTK_BUTTON(check_button), GTK_RELIEF_NONE);
    gtk_container_add(GTK_CONTAINER(check_button), save_for_later);
    gtk_widget_show(GTK_WIDGET(check_button));

    saveForLaterPtr sfl = g_new0(struct saveForLater, 1);
    sfl->ip = ip;
    sfl->titleLabel = titleLabel;

    g_signal_connect((gpointer) check_button, "toggled",
	     G_CALLBACK(save_for_later_clicked_cb), sfl);
    g_signal_connect((gpointer) check_button, "destroy",
		     G_CALLBACK(save_for_later_destroy_cb), sfl);

    /* Separator bar */
    separator = gtk_label_new(NULL);
    gtk_label_set_markup(GTK_LABEL(separator), "| ");
    widget_alter_font_size(separator, FONT_SIZE, TRUE, FALSE);
    gtk_widget_show(GTK_WIDGET(separator));
    
    /* Send as e-mail link */
    send = gtk_label_new(NULL);
    tmp =
	g_strdup_printf("<span foreground=\"blue\" underline=\"single\">%s</span>",
			_("rss_ia_send_post"));
    gtk_label_set_markup(GTK_LABEL(send), tmp);
    g_free(tmp);
    gtk_label_set_use_underline(GTK_LABEL(send), TRUE);
    widget_alter_font_size(send, FONT_SIZE, TRUE, FALSE);
    gtk_widget_show(GTK_WIDGET(send));

    GtkEventBox *child_container = GTK_EVENT_BOX(gtk_event_box_new());
    gtk_container_add(GTK_CONTAINER(child_container), send);
    gtk_widget_show(GTK_WIDGET(child_container));
    
    g_signal_connect((gpointer) child_container, "button_press_event",
		     G_CALLBACK(send_as_email_clicked_cb), ip);

    /* hbox for all the action widgets in full screen mode
       or all but the time and date label in the folders mode */
    hbox = gtk_hbox_new(FALSE,0);

    gtk_widget_size_request(GTK_WIDGET(check_button), &req_checkbutton);
	 
    gtk_widget_set_usize(GTK_WIDGET(check_button), req_checkbutton.width + 2, 0);
  
    GtkRequisition req_time_and_date;
    GtkRequisition req_separator;
    GtkRequisition req_send;
    GtkRequisition req_vscrollbar;
    int req_total = 0;
    
    gtk_widget_size_request(GTK_WIDGET(time_and_date_width), &req_time_and_date);
    gtk_widget_size_request(GTK_WIDGET(separator), &req_separator);
    gtk_widget_size_request(GTK_WIDGET(child_container), &req_send);
    gtk_widget_size_request(GTK_WIDGET(check_button), &req_checkbutton);
    gtk_widget_size_request(GTK_SCROLLED_WINDOW(scrollpane)->vscrollbar, &req_vscrollbar);

    req_total = req_time_and_date.width + req_separator.width + req_send.width + req_checkbutton.width;
    
    if(req_total < GTK_WIDGET(scrollpane)->allocation.width - req_vscrollbar.width)
        two_line_mode = FALSE;
    
    if(two_line_mode)		     
    {
         vbox = gtk_vbox_new(FALSE, 0);
	 gtk_widget_show(vbox);

         gtk_box_pack_start(GTK_BOX(hbox),GTK_WIDGET(check_button),FALSE,FALSE,0);				      				      
	 gtk_box_pack_start(GTK_BOX(hbox),GTK_WIDGET(separator),FALSE,FALSE,0);
	 gtk_box_pack_start(GTK_BOX(hbox),GTK_WIDGET(child_container),FALSE,FALSE,0);
	 
	 gtk_box_pack_start(GTK_BOX(vbox),alignment,FALSE,FALSE,0);
	 gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	 
	 gtk_text_view_add_child_at_anchor(GTK_TEXT_VIEW(htmlwidget),
				          GTK_WIDGET(vbox), anchor);
    }	
    else
    {
         gtk_box_pack_start(GTK_BOX(hbox),GTK_WIDGET(alignment),FALSE,FALSE,0);
	 gtk_box_pack_start(GTK_BOX(hbox),GTK_WIDGET(check_button),FALSE,FALSE,0);
	 gtk_box_pack_start(GTK_BOX(hbox),GTK_WIDGET(separator),FALSE,FALSE,0);
	 gtk_box_pack_start(GTK_BOX(hbox),GTK_WIDGET(child_container),FALSE,FALSE,0);
    
         gtk_text_view_add_child_at_anchor(GTK_TEXT_VIEW(htmlwidget),
				          GTK_WIDGET(hbox), anchor);    		     
    }					  
    gtk_widget_show(hbox);
    
    widget_alter_font_size(htmlwidget, FONT_SIZE, TRUE, FALSE);
    		
    /* Ending newline */
    gtk_text_buffer_insert(buffer, &iter, "\n", -1);
}

void textview_render_item(itemPtr ip)
{
    GtkTextBuffer *buffer =
	GTK_TEXT_BUFFER(gtk_text_view_get_buffer
			(GTK_TEXT_VIEW(htmlwidget)));

    GtkTextIter iter;
    gchar *mark_name = g_strdup_printf("nr%ld", ip->nr);
    gtk_text_buffer_get_end_iter(buffer, &iter);
    gtk_text_buffer_create_mark(buffer, mark_name, &iter, TRUE);
    g_free(mark_name);

    GtkLabel *titleLabel = append_title(buffer, ip);

    if (item_get_description(ip) != NULL) {
	append_to_buffer(buffer, item_get_description(ip));
	gtk_text_buffer_get_end_iter(buffer, &iter);
	gtk_text_buffer_insert(buffer, &iter, "\n", 1);
    }
    append_actions(buffer, ip, titleLabel);
}

void textview_render_empty_feed()
{
    GtkTextBuffer *buffer =
	GTK_TEXT_BUFFER(gtk_text_view_get_buffer
			(GTK_TEXT_VIEW(htmlwidget)));

    append_to_buffer(buffer, _("rss_ia_no_posts"));	
    widget_alter_font_size(htmlwidget, FONT_SIZE, TRUE, FALSE);		
}

int textview_get_vertical_scroll_position()
{
    GtkAdjustment *adjustment = NULL;
    
    g_assert(scrollpane != NULL);
    
    adjustment = gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(scrollpane));
   
    return (int)gtk_adjustment_get_value(adjustment); 
}

gboolean textview_set_vertical_scroll_position()
{
    GtkAdjustment *adjustment = NULL;
    
    g_assert(scrollpane != NULL);
    g_assert(app_data != NULL);
    g_assert(app_data->app_ui_data != NULL);
  
    adjustment = gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(scrollpane));

    adjustment->value = (double)app_data->app_ui_data->vertical_scroll_window_position;
    gtk_adjustment_value_changed(adjustment);
    
    return FALSE;
}

static htmlviewPluginInfo gtktextviewInfo = {
    HTMLVIEW_API_VERSION,
    "GtkTextView",
    gtktextview_init,
    gtktextview_deinit,
    gtktextview_new,
    write_html,
    launch_url,
    launch_inside_possible,
    get_zoom_level,
    change_zoom_level,
    gtktextview_scroll_pagedown,
    /* setProxy = */ NULL,
    textview_get_buffer,
    textview_render_item
};

//DECLARE_HTMLVIEW_PLUGIN(gtktextviewInfo);
