/**
 * Copyright (c) 2005-06 Nokia Corporation. All rights reserved.
 * Contact: Ouyang Qi <qi.ouyang@nokia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Initial developer(s): Pinter Sandor, Zsolt Simon
 */

#include <glib.h>
#include "enclosure.h"



gchar *enclosure_get_url(struct enclosure_attribute *attrib)
{
  g_assert(attrib);
  return attrib->ul;
}


gchar *enclosure_get_type(struct enclosure_attribute *attrib)
{
  g_assert(attrib);
  return attrib->type;
}


gint enclosure_get_length(struct enclosure_attribute *attrib)
{
  g_assert(attrib);
  return attrib->length;
}

struct enclosure_attribute *enclosure_dup_enclosure(struct enclosure_attribute *attrib)
{
    g_assert(attrib);
    
    struct enclosure_attribute *result = g_new0(struct enclosure_attribute,1);
    if (attrib->ul)
        result->ul = g_strdup(attrib->ul);
    if (attrib->type)
        result->type = g_strdup(attrib->ul);
    result->length = attrib->length;
    
    return result;
}

struct enclosure_attribute *enclosure_free_enclosure(struct enclosure_attribute *attrib)
{
  g_assert(attrib);
  if (attrib->ul)
  {
    g_free(attrib->ul);
  }
  if (attrib->type)
  {
    g_free(attrib->type);
  }
  g_free(attrib);
  return NULL;
}

void enclosure_set_url(struct enclosure_attribute *attrib,const gchar *url)
{
  g_assert(attrib);
  g_assert(url);
  if (attrib->ul!=NULL)
  {
    g_free(attrib->ul);
    attrib->ul=NULL;
  }
  attrib->ul=g_strdup(url);
  
}

void enclosure_set_type(struct enclosure_attribute *attrib,const gchar *type)
{
  g_assert(attrib);
  g_assert(type);
  if (attrib->type!=NULL)
  {
    g_free(attrib->type);
    attrib->type=NULL;
  }
  attrib->type=g_strdup(type);
}

void enclosure_set_length(struct enclosure_attribute *attrib,const gint length)
{
  g_assert(attrib);
  attrib->length=length;
}
